/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.auth.oauth2;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import shaded.bqjdbc.com.google.api.client.json.JsonFactory;
import shaded.bqjdbc.com.google.api.client.json.webtoken.JsonWebSignature;
import shaded.bqjdbc.com.google.auth.oauth2.AccessToken;
import shaded.bqjdbc.com.google.auth.oauth2.OAuth2Utils;
import shaded.bqjdbc.com.google.common.base.MoreObjects;

public class IdToken
extends AccessToken
implements Serializable {
    private static final long serialVersionUID = -8514239465808977353L;
    private transient JsonWebSignature jsonWebSignature;

    private IdToken(String tokenValue, JsonWebSignature jsonWebSignature) {
        super(tokenValue, new Date(jsonWebSignature.getPayload().getExpirationTimeSeconds() * 1000L));
        this.jsonWebSignature = jsonWebSignature;
    }

    public static IdToken create(String tokenValue) throws IOException {
        return IdToken.create(tokenValue, OAuth2Utils.JSON_FACTORY);
    }

    public static IdToken create(String tokenValue, JsonFactory jsonFactory) throws IOException {
        return new IdToken(tokenValue, JsonWebSignature.parse(jsonFactory, tokenValue));
    }

    JsonWebSignature getJsonWebSignature() {
        return this.jsonWebSignature;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.getTokenValue(), this.jsonWebSignature.getHeader(), this.jsonWebSignature.getPayload());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("tokenValue", super.getTokenValue()).add("JsonWebSignature", this.jsonWebSignature).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IdToken)) {
            return false;
        }
        IdToken other = (IdToken)obj;
        return Objects.equals(super.getTokenValue(), other.getTokenValue()) && Objects.equals(this.jsonWebSignature.getHeader(), other.jsonWebSignature.getHeader()) && Objects.equals(this.jsonWebSignature.getPayload(), other.jsonWebSignature.getPayload());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.getTokenValue());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        String signature = (String)ois.readObject();
        this.jsonWebSignature = JsonWebSignature.parse(OAuth2Utils.JSON_FACTORY, signature);
    }
}

