/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.auth.oauth2;

import java.util.Map;
import java.util.logging.Level;
import shaded.bqjdbc.com.google.api.client.http.HttpRequest;
import shaded.bqjdbc.com.google.api.client.http.HttpResponse;
import shaded.bqjdbc.com.google.api.client.util.GenericData;
import shaded.bqjdbc.com.google.auth.oauth2.EnvironmentProvider;
import shaded.bqjdbc.com.google.auth.oauth2.LoggerProvider;
import shaded.bqjdbc.com.google.auth.oauth2.Slf4jLoggingHelpers;
import shaded.bqjdbc.com.google.auth.oauth2.SystemEnvironmentProvider;

class LoggingUtils {
    static final String GOOGLE_SDK_JAVA_LOGGING = "GOOGLE_SDK_JAVA_LOGGING";
    private static EnvironmentProvider environmentProvider = SystemEnvironmentProvider.getInstance();
    private static boolean loggingEnabled = LoggingUtils.isLoggingEnabled();

    static void setEnvironmentProvider(EnvironmentProvider provider) {
        environmentProvider = provider;
        loggingEnabled = LoggingUtils.isLoggingEnabled();
    }

    static boolean isLoggingEnabled() {
        String enableLogging = environmentProvider.getEnv(GOOGLE_SDK_JAVA_LOGGING);
        return "true".equalsIgnoreCase(enableLogging);
    }

    static void logRequest(HttpRequest request, LoggerProvider loggerProvider, String message) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.logRequest(request, loggerProvider, message);
        }
    }

    static void logResponse(HttpResponse response, LoggerProvider loggerProvider, String message) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.logResponse(response, loggerProvider, message);
        }
    }

    static void logResponsePayload(GenericData genericData, LoggerProvider loggerProvider, String message) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.logResponsePayload(genericData, loggerProvider, message);
        }
    }

    static void log(LoggerProvider loggerProvider, Level level, Map<String, Object> contextMap, String message) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.log(loggerProvider, level, contextMap, message);
        }
    }

    private LoggingUtils() {
    }
}

