/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.auth.oauth2;

import java.io.IOException;
import java.util.Map;
import shaded.bqjdbc.com.google.api.client.http.GenericUrl;
import shaded.bqjdbc.com.google.api.client.http.HttpHeaders;
import shaded.bqjdbc.com.google.api.client.http.HttpRequest;
import shaded.bqjdbc.com.google.api.client.http.HttpResponse;
import shaded.bqjdbc.com.google.api.client.json.JsonObjectParser;
import shaded.bqjdbc.com.google.auth.http.HttpTransportFactory;
import shaded.bqjdbc.com.google.auth.oauth2.ExternalAccountSupplierContext;
import shaded.bqjdbc.com.google.auth.oauth2.FileIdentityPoolSubjectTokenSupplier;
import shaded.bqjdbc.com.google.auth.oauth2.IdentityPoolCredentialSource;
import shaded.bqjdbc.com.google.auth.oauth2.IdentityPoolSubjectTokenSupplier;
import shaded.bqjdbc.com.google.auth.oauth2.OAuth2Utils;

class UrlIdentityPoolSubjectTokenSupplier
implements IdentityPoolSubjectTokenSupplier {
    private static final long serialVersionUID = 4964578313468011844L;
    private final IdentityPoolCredentialSource credentialSource;
    private final transient HttpTransportFactory transportFactory;

    UrlIdentityPoolSubjectTokenSupplier(IdentityPoolCredentialSource credentialSource, HttpTransportFactory transportFactory) {
        this.credentialSource = credentialSource;
        this.transportFactory = transportFactory;
    }

    @Override
    public String getSubjectToken(ExternalAccountSupplierContext context) throws IOException {
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildGetRequest(new GenericUrl(this.credentialSource.getCredentialLocation()));
        request.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        if (this.credentialSource.hasHeaders()) {
            HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map<? extends String, ?>)this.credentialSource.headers);
            request.setHeaders(headers);
        }
        try {
            HttpResponse response = request.execute();
            return FileIdentityPoolSubjectTokenSupplier.parseToken(response.getContent(), this.credentialSource);
        }
        catch (IOException e) {
            throw new IOException(String.format("Error getting subject token from metadata server: %s", e.getMessage()), e);
        }
    }
}

