/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.io.Serializable;
import java.util.Objects;
import shaded.bqjdbc.com.google.api.services.bigquery.model.ErrorProto;
import shaded.bqjdbc.com.google.common.base.Function;
import shaded.bqjdbc.com.google.common.base.MoreObjects;

public final class BigQueryError
implements Serializable {
    static final Function<ErrorProto, BigQueryError> FROM_PB_FUNCTION = new Function<ErrorProto, BigQueryError>(){

        @Override
        public BigQueryError apply(ErrorProto pb) {
            return BigQueryError.fromPb(pb);
        }
    };
    static final Function<BigQueryError, ErrorProto> TO_PB_FUNCTION = new Function<BigQueryError, ErrorProto>(){

        @Override
        public ErrorProto apply(BigQueryError error) {
            return error.toPb();
        }
    };
    private static final long serialVersionUID = -6566785320629096688L;
    private final String reason;
    private final String location;
    private final String debugInfo;
    private final String message;

    public BigQueryError(String reason, String location, String message, String debugInfo) {
        this.reason = reason;
        this.location = location;
        this.debugInfo = debugInfo;
        this.message = message;
    }

    public BigQueryError(String reason, String location, String message) {
        this.reason = reason;
        this.location = location;
        this.message = message;
        this.debugInfo = null;
    }

    public String getReason() {
        return this.reason;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return Objects.hash(this.reason, this.location, this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("reason", this.reason).add("location", this.location).add("message", this.message).toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BigQueryError && Objects.equals(this.toPb(), ((BigQueryError)obj).toPb());
    }

    ErrorProto toPb() {
        ErrorProto errorPb = new ErrorProto();
        if (this.reason != null) {
            errorPb.setReason(this.reason);
        }
        if (this.location != null) {
            errorPb.setLocation(this.location);
        }
        if (this.message != null) {
            errorPb.setMessage(this.message);
        }
        if (this.debugInfo != null) {
            errorPb.setDebugInfo(this.debugInfo);
        }
        return errorPb;
    }

    static BigQueryError fromPb(ErrorProto errorPb) {
        return new BigQueryError(errorPb.getReason(), errorPb.getLocation(), errorPb.getMessage(), errorPb.getDebugInfo());
    }
}

