/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.bqjdbc.com.google.api.core.ApiClock;
import shaded.bqjdbc.com.google.api.gax.retrying.DirectRetryingExecutor;
import shaded.bqjdbc.com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import shaded.bqjdbc.com.google.api.gax.retrying.ResultRetryAlgorithm;
import shaded.bqjdbc.com.google.api.gax.retrying.RetrySettings;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryingFuture;
import shaded.bqjdbc.com.google.api.gax.retrying.TimedRetryAlgorithm;
import shaded.bqjdbc.com.google.cloud.RetryHelper;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQueryException;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQueryRetryAlgorithm;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQueryRetryConfig;
import shaded.bqjdbc.io.opentelemetry.api.trace.Tracer;
import shaded.bqjdbc.io.opentelemetry.context.ImplicitContextKeyed;
import shaded.bqjdbc.io.opentelemetry.context.Scope;

public class BigQueryRetryHelper
extends RetryHelper {
    private static final Logger LOG = Logger.getLogger(BigQueryRetryHelper.class.getName());

    public static <V> V runWithRetries(Callable<V> callable, RetrySettings retrySettings, ResultRetryAlgorithm<?> resultRetryAlgorithm, ApiClock clock, BigQueryRetryConfig bigQueryRetryConfig, boolean isOpenTelemetryEnabled, Tracer openTelemetryTracer) throws RetryHelper.RetryHelperException {
        ImplicitContextKeyed runWithRetries = null;
        if (isOpenTelemetryEnabled && openTelemetryTracer != null) {
            runWithRetries = openTelemetryTracer.spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.BigQueryRetryHelper.runWithRetries").startSpan();
        }
        try {
            V v;
            block14: {
                Scope runWithRetriesScope = runWithRetries != null ? runWithRetries.makeCurrent() : null;
                try {
                    ResultRetryAlgorithm<?> algorithm = resultRetryAlgorithm;
                    v = BigQueryRetryHelper.run(callable, new ExponentialRetryAlgorithm(retrySettings, clock), algorithm, bigQueryRetryConfig);
                    if (runWithRetriesScope == null) break block14;
                    runWithRetriesScope.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (runWithRetriesScope != null) {
                            try {
                                runWithRetriesScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof IOException) {
                            throw new BigQueryRetryHelperException(new BigQueryException((IOException)e.getCause()));
                        }
                        throw new BigQueryRetryHelperException(e.getCause());
                    }
                }
            }
            return v;
        }
        finally {
            if (runWithRetries != null) {
                runWithRetries.end();
            }
        }
    }

    private static <V> V run(Callable<V> callable, TimedRetryAlgorithm timedAlgorithm, ResultRetryAlgorithm<V> resultAlgorithm, BigQueryRetryConfig bigQueryRetryConfig) throws ExecutionException, InterruptedException {
        BigQueryRetryAlgorithm<V> retryAlgorithm = new BigQueryRetryAlgorithm<V>(resultAlgorithm, timedAlgorithm, bigQueryRetryConfig);
        DirectRetryingExecutor<V> executor = new DirectRetryingExecutor<V>(retryAlgorithm);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Retrying with:\n{0}\n{1}", new Object[]{"BigQuery retried method: " + callable.getClass().getEnclosingMethod().getName(), "BigQuery retry settings: " + timedAlgorithm.createFirstAttempt().getGlobalSettings()});
        }
        RetryingFuture<V> retryingFuture = executor.createFuture(callable);
        executor.submit(retryingFuture);
        return retryingFuture.get();
    }

    public static class BigQueryRetryHelperException
    extends RuntimeException {
        private static final long serialVersionUID = -8519852520090965314L;

        BigQueryRetryHelperException(Throwable cause) {
            super(cause);
        }
    }
}

