/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.util.List;
import java.util.Objects;
import shaded.bqjdbc.com.google.cloud.bigquery.FormatOptions;
import shaded.bqjdbc.com.google.common.base.MoreObjects;

public final class DatastoreBackupOptions
extends FormatOptions {
    private final List<String> projectionFields;
    private static final long serialVersionUID = -5302774763661451947L;

    private DatastoreBackupOptions(Builder builder) {
        super("DATASTORE_BACKUP");
        this.projectionFields = builder.projectionFields;
    }

    public List<String> getProjectionFields() {
        return this.projectionFields;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("projectionFields", this.projectionFields).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getType(), this.projectionFields);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof DatastoreBackupOptions && Objects.equals(this.projectionFields, ((DatastoreBackupOptions)obj).getProjectionFields());
    }

    public static final class Builder {
        private List<String> projectionFields;

        private Builder() {
        }

        private Builder(DatastoreBackupOptions options) {
            this.projectionFields = options.projectionFields;
        }

        public Builder setProjectionFields(List<String> projectionFields) {
            this.projectionFields = projectionFields;
            return this;
        }

        public DatastoreBackupOptions build() {
            return new DatastoreBackupOptions(this);
        }
    }
}

