/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.io.Serializable;
import java.util.Objects;
import shaded.bqjdbc.com.google.cloud.bigquery.AvroOptions;
import shaded.bqjdbc.com.google.cloud.bigquery.BigtableOptions;
import shaded.bqjdbc.com.google.cloud.bigquery.CsvOptions;
import shaded.bqjdbc.com.google.cloud.bigquery.DatastoreBackupOptions;
import shaded.bqjdbc.com.google.cloud.bigquery.GoogleSheetsOptions;
import shaded.bqjdbc.com.google.cloud.bigquery.ParquetOptions;
import shaded.bqjdbc.com.google.common.base.MoreObjects;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.base.Strings;

public class FormatOptions
implements Serializable {
    static final String CSV = "CSV";
    static final String JSON = "NEWLINE_DELIMITED_JSON";
    static final String BIGTABLE = "BIGTABLE";
    static final String DATASTORE_BACKUP = "DATASTORE_BACKUP";
    static final String AVRO = "AVRO";
    static final String GOOGLE_SHEETS = "GOOGLE_SHEETS";
    static final String PARQUET = "PARQUET";
    static final String ORC = "ORC";
    static final String ICEBERG = "ICEBERG";
    private static final long serialVersionUID = -443376052020423691L;
    private final String type;

    FormatOptions(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("format", this.type).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(FormatOptions.class) && Objects.equals(this.type, ((FormatOptions)obj).getType());
    }

    public static CsvOptions csv() {
        return CsvOptions.newBuilder().build();
    }

    public static FormatOptions json() {
        return new FormatOptions(JSON);
    }

    public static FormatOptions datastoreBackup() {
        return DatastoreBackupOptions.newBuilder().build();
    }

    public static AvroOptions avro() {
        return AvroOptions.newBuilder().build();
    }

    public static FormatOptions bigtable() {
        return BigtableOptions.newBuilder().build();
    }

    public static FormatOptions googleSheets() {
        return GoogleSheetsOptions.newBuilder().build();
    }

    public static FormatOptions parquet() {
        return ParquetOptions.newBuilder().build();
    }

    public static FormatOptions orc() {
        return new FormatOptions(ORC);
    }

    public static FormatOptions iceberg() {
        return new FormatOptions(ICEBERG);
    }

    public static FormatOptions of(String format) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(format), "Provided format is null or empty");
        if (format.equals(CSV)) {
            return FormatOptions.csv();
        }
        if (format.equals(AVRO)) {
            return FormatOptions.avro();
        }
        if (format.equals(DATASTORE_BACKUP)) {
            return FormatOptions.datastoreBackup();
        }
        if (format.equals(GOOGLE_SHEETS)) {
            return FormatOptions.googleSheets();
        }
        if (format.equals(BIGTABLE)) {
            return FormatOptions.bigtable();
        }
        if (format.equals(PARQUET)) {
            return FormatOptions.parquet();
        }
        if (format.equals(ICEBERG)) {
            return FormatOptions.iceberg();
        }
        return new FormatOptions(format);
    }
}

