/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import shaded.bqjdbc.com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import shaded.bqjdbc.com.google.api.gax.retrying.RetrySettings;
import shaded.bqjdbc.com.google.api.gax.retrying.TimedAttemptSettings;
import shaded.bqjdbc.com.google.cloud.PageImpl;
import shaded.bqjdbc.com.google.cloud.RetryHelper;
import shaded.bqjdbc.com.google.cloud.RetryOption;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQuery;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQueryException;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQueryOptions;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQueryRetryConfig;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQueryRetryHelper;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldValueList;
import shaded.bqjdbc.com.google.cloud.bigquery.JobConfiguration;
import shaded.bqjdbc.com.google.cloud.bigquery.JobException;
import shaded.bqjdbc.com.google.cloud.bigquery.JobId;
import shaded.bqjdbc.com.google.cloud.bigquery.JobInfo;
import shaded.bqjdbc.com.google.cloud.bigquery.JobStatistics;
import shaded.bqjdbc.com.google.cloud.bigquery.JobStatus;
import shaded.bqjdbc.com.google.cloud.bigquery.Option;
import shaded.bqjdbc.com.google.cloud.bigquery.QueryJobConfiguration;
import shaded.bqjdbc.com.google.cloud.bigquery.QueryResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.TableId;
import shaded.bqjdbc.com.google.cloud.bigquery.TableResult;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.io.opentelemetry.api.common.Attributes;
import shaded.bqjdbc.io.opentelemetry.context.ImplicitContextKeyed;
import shaded.bqjdbc.io.opentelemetry.context.Scope;

public class Job
extends JobInfo {
    private static final long serialVersionUID = -4324100991693024704L;
    private static final RetrySettings DEFAULT_JOB_WAIT_SETTINGS = RetrySettings.newBuilder().setTotalTimeoutDuration(Duration.ofHours(12L)).setInitialRetryDelayDuration(Duration.ofSeconds(1L)).setRetryDelayMultiplier(2.0).setJittered(true).setMaxRetryDelayDuration(Duration.ofMinutes(1L)).build();
    static final RetrySettings DEFAULT_QUERY_JOB_WAIT_SETTINGS = RetrySettings.newBuilder().setTotalTimeoutDuration(Duration.ofHours(12L)).setInitialRetryDelayDuration(Duration.ofSeconds(3L)).setRetryDelayMultiplier(1.0).setJittered(true).setMaxRetryDelayDuration(Duration.ofSeconds(3L)).build();
    static final BigQuery.QueryResultsOption[] DEFAULT_QUERY_WAIT_OPTIONS = new BigQuery.QueryResultsOption[]{BigQuery.QueryResultsOption.pageSize(0L)};
    private final BigQueryOptions options;
    private transient BigQuery bigquery;
    private static final BigQueryRetryConfig DEFAULT_RETRY_CONFIG = BigQueryRetryConfig.newBuilder().retryOnMessage("Exceeded rate limits:").build();

    Job(BigQuery bigquery, JobInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.bigquery = Preconditions.checkNotNull(bigquery);
        this.options = (BigQueryOptions)bigquery.getOptions();
    }

    public boolean exists() {
        this.checkNotDryRun("exists");
        ImplicitContextKeyed exists = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            exists = this.options.getOpenTelemetryTracer().spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.Job.exists").startSpan();
        }
        try {
            Scope existsScope = exists != null ? exists.makeCurrent() : null;
            try {
                boolean bl;
                boolean bl2 = bl = this.bigquery.getJob(this.getJobId(), BigQuery.JobOption.fields(new BigQuery.JobField[0])) != null;
                if (existsScope != null) {
                    existsScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (existsScope != null) {
                    try {
                        existsScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (exists != null) {
                exists.end();
            }
        }
    }

    public boolean isDone() {
        this.checkNotDryRun("isDone");
        ImplicitContextKeyed isDone = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            isDone = this.options.getOpenTelemetryTracer().spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.Job.isDone").startSpan();
        }
        try {
            Scope isDoneScope = isDone != null ? isDone.makeCurrent() : null;
            try {
                boolean bl;
                Job job = this.bigquery.getJob(this.getJobId(), BigQuery.JobOption.fields(BigQuery.JobField.STATUS));
                boolean bl2 = bl = job == null || JobStatus.State.DONE.equals(job.getStatus().getState());
                if (isDoneScope != null) {
                    isDoneScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (isDoneScope != null) {
                    try {
                        isDoneScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (isDone != null) {
                isDone.end();
            }
        }
    }

    public Job waitFor(RetryOption ... waitOptions) throws InterruptedException {
        return this.waitForInternal(DEFAULT_RETRY_CONFIG, waitOptions);
    }

    public Job waitFor(BigQueryRetryConfig bigQueryRetryConfig, RetryOption ... waitOptions) throws InterruptedException {
        return this.waitForInternal(bigQueryRetryConfig, waitOptions);
    }

    private Job waitForInternal(BigQueryRetryConfig bigQueryRetryConfig, RetryOption ... waitOptions) throws InterruptedException {
        this.checkNotDryRun("waitFor");
        ImplicitContextKeyed waitFor = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            waitFor = this.options.getOpenTelemetryTracer().spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.Job.waitFor").startSpan();
        }
        try {
            Scope waitForScope = waitFor != null ? waitFor.makeCurrent() : null;
            try {
                Job job;
                Object completedJobResponse = ((JobConfiguration)this.getConfiguration()).getType() == JobConfiguration.Type.QUERY ? this.waitForQueryResults(RetryOption.mergeToSettings(DEFAULT_JOB_WAIT_SETTINGS, waitOptions), bigQueryRetryConfig, DEFAULT_QUERY_WAIT_OPTIONS) : this.waitForJob(RetryOption.mergeToSettings(DEFAULT_QUERY_JOB_WAIT_SETTINGS, waitOptions));
                Job job2 = job = completedJobResponse == null ? null : this.reload(new BigQuery.JobOption[0]);
                if (waitForScope != null) {
                    waitForScope.close();
                }
                return job;
            }
            catch (Throwable throwable) {
                if (waitForScope != null) {
                    try {
                        waitForScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (waitFor != null) {
                waitFor.end();
            }
        }
    }

    public TableResult getQueryResults(BigQuery.QueryResultsOption ... options) throws InterruptedException, JobException {
        this.checkNotDryRun("getQueryResults");
        ImplicitContextKeyed getQueryResults = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getQueryResults = this.options.getOpenTelemetryTracer().spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.Job.getQueryResults").setAllAttributes(Job.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            TableResult tableResultWithJobId;
            Job job;
            QueryResponse response;
            ArrayList<BigQuery.TableDataListOption> listOptions;
            Scope getQueryResultsScope;
            block25: {
                getQueryResultsScope = getQueryResults != null ? getQueryResults.makeCurrent() : null;
                try {
                    Serializable option2;
                    if (((JobConfiguration)this.getConfiguration()).getType() != JobConfiguration.Type.QUERY) {
                        throw new UnsupportedOperationException("Getting query results is supported only for " + (Object)((Object)JobConfiguration.Type.QUERY) + " jobs");
                    }
                    ArrayList<BigQuery.QueryResultsOption> waitOptions = new ArrayList<BigQuery.QueryResultsOption>(Arrays.asList(DEFAULT_QUERY_WAIT_OPTIONS));
                    listOptions = new ArrayList<BigQuery.TableDataListOption>();
                    block16: for (Serializable option2 : options) {
                        switch (option2.getRpcOption()) {
                            case MAX_RESULTS: {
                                listOptions.add(BigQuery.TableDataListOption.pageSize((Long)option2.getValue()));
                                continue block16;
                            }
                            case PAGE_TOKEN: {
                                listOptions.add(BigQuery.TableDataListOption.pageToken((String)option2.getValue()));
                                continue block16;
                            }
                            case START_INDEX: {
                                listOptions.add(BigQuery.TableDataListOption.startIndex((Long)option2.getValue()));
                                continue block16;
                            }
                            case TIMEOUT: {
                                waitOptions.add(BigQuery.QueryResultsOption.maxWaitTime((Long)option2.getValue()));
                            }
                        }
                    }
                    response = this.waitForQueryResults(DEFAULT_JOB_WAIT_SETTINGS, DEFAULT_RETRY_CONFIG, waitOptions.toArray(new BigQuery.QueryResultsOption[0]));
                    job = this;
                    if (job.getStatus() == null || !JobStatus.State.DONE.equals(job.getStatus().getState())) {
                        job = this.reload(new BigQuery.JobOption[0]);
                    }
                    if (job.getStatus() != null && job.getStatus().getError() != null) {
                        throw new BigQueryException(job.getStatus().getExecutionErrors() == null ? ImmutableList.of(job.getStatus().getError()) : ImmutableList.copyOf(job.getStatus().getExecutionErrors()));
                    }
                    if (response.getTotalRows() != 0L) break block25;
                    TableResult emptyTableResult = TableResult.newBuilder().setSchema(response.getSchema()).setJobId(job.getJobId()).setTotalRows(0L).setPageNoSchema(new PageImpl<FieldValueList>(null, "", null)).build();
                    option2 = emptyTableResult;
                    if (getQueryResultsScope != null) {
                        getQueryResultsScope.close();
                    }
                    return option2;
                }
                catch (Throwable throwable) {
                    if (getQueryResultsScope != null) {
                        try {
                            getQueryResultsScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            TableId table = ((QueryJobConfiguration)this.getConfiguration()).getDestinationTable() == null ? ((QueryJobConfiguration)job.getConfiguration()).getDestinationTable() : ((QueryJobConfiguration)this.getConfiguration()).getDestinationTable();
            TableResult tableResult = this.bigquery.listTableData(table, response.getSchema(), listOptions.toArray(new BigQuery.TableDataListOption[0]));
            TableResult tableResult2 = tableResultWithJobId = tableResult.toBuilder().setJobId(job.getJobId()).build();
            if (getQueryResultsScope != null) {
                getQueryResultsScope.close();
            }
            return tableResult2;
        }
        finally {
            if (getQueryResults != null) {
                getQueryResults.end();
            }
        }
    }

    private QueryResponse waitForQueryResults(RetrySettings retrySettings, BigQueryRetryConfig bigQueryRetryConfig, final BigQuery.QueryResultsOption ... resultsOptions) throws InterruptedException {
        if (((JobConfiguration)this.getConfiguration()).getType() != JobConfiguration.Type.QUERY) {
            throw new UnsupportedOperationException("Waiting for query results is supported only for " + (Object)((Object)JobConfiguration.Type.QUERY) + " jobs");
        }
        ImplicitContextKeyed waitForQueryResults = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            waitForQueryResults = this.options.getOpenTelemetryTracer().spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.Job.waitForQueryResults").setAllAttributes(Job.otelAttributesFromOptions(resultsOptions)).startSpan();
        }
        try {
            Scope waitForQueryResultsScope = waitForQueryResults != null ? waitForQueryResults.makeCurrent() : null;
            try {
                QueryResponse queryResponse = BigQueryRetryHelper.runWithRetries(new Callable<QueryResponse>(){

                    @Override
                    public QueryResponse call() {
                        return Job.this.bigquery.getQueryResults(Job.this.getJobId(), resultsOptions);
                    }
                }, retrySettings, new BasicResultRetryAlgorithm<QueryResponse>(){

                    @Override
                    public boolean shouldRetry(Throwable prevThrowable, QueryResponse prevResponse) {
                        return prevResponse != null && !prevResponse.getCompleted();
                    }
                }, this.options.getClock(), bigQueryRetryConfig, this.options.isOpenTelemetryTracingEnabled(), this.options.getOpenTelemetryTracer());
                if (waitForQueryResultsScope != null) {
                    waitForQueryResultsScope.close();
                }
                return queryResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (waitForQueryResultsScope != null) {
                        try {
                            waitForQueryResultsScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (waitForQueryResults != null) {
                waitForQueryResults.end();
            }
        }
    }

    private Job waitForJob(RetrySettings waitSettings) throws InterruptedException {
        ImplicitContextKeyed waitForJob = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            waitForJob = this.options.getOpenTelemetryTracer().spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.Job.waitForJob").setAttribute("bq.job.wait_settings.total_timeout", Job.getFieldAsString(waitSettings.getTotalTimeoutDuration())).setAttribute("bq.job.wait_settings.initial_retry_delay", Job.getFieldAsString(waitSettings.getInitialRetryDelayDuration())).setAttribute("bq.job.wait_settings.max_retry_delay", Job.getFieldAsString(waitSettings.getMaxRetryDelayDuration())).setAttribute("bq.job.wait_settings.initial_rpc_timeout", Job.getFieldAsString(waitSettings.getInitialRpcTimeoutDuration())).setAttribute("bq.job.wait_settings.max_rpc_timeout", Job.getFieldAsString(waitSettings.getMaxRpcTimeoutDuration())).startSpan();
        }
        try {
            Scope waitForJobScope = waitForJob != null ? waitForJob.makeCurrent() : null;
            try {
                Job job = RetryHelper.poll(new Callable<Job>(){

                    @Override
                    public Job call() throws Exception {
                        return Job.this.bigquery.getJob(Job.this.getJobId(), BigQuery.JobOption.fields(BigQuery.JobField.STATUS));
                    }
                }, waitSettings, new BasicResultRetryAlgorithm<Job>(){

                    @Override
                    public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, Job prevResponse, TimedAttemptSettings prevSettings) {
                        return null;
                    }

                    @Override
                    public boolean shouldRetry(Throwable prevThrowable, Job prevResponse) {
                        return prevResponse != null && !JobStatus.State.DONE.equals(prevResponse.getStatus().getState());
                    }
                }, this.options.getClock());
                if (waitForJobScope != null) {
                    waitForJobScope.close();
                }
                return job;
            }
            catch (Throwable throwable) {
                try {
                    if (waitForJobScope != null) {
                        try {
                            waitForJobScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExecutionException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (waitForJob != null) {
                waitForJob.end();
            }
        }
    }

    public Job reload(BigQuery.JobOption ... options) {
        this.checkNotDryRun("reload");
        ImplicitContextKeyed reload = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            reload = this.options.getOpenTelemetryTracer().spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.Job.reload").setAllAttributes(Job.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope reloadScope = reload != null ? reload.makeCurrent() : null;
            try {
                Job job = this.bigquery.getJob(this.getJobId(), options);
                if (job != null && job.getStatus().getError() != null) {
                    throw new BigQueryException(job.getStatus().getExecutionErrors() == null ? ImmutableList.of(job.getStatus().getError()) : ImmutableList.copyOf(job.getStatus().getExecutionErrors()));
                }
                Job job2 = job;
                if (reloadScope != null) {
                    reloadScope.close();
                }
                return job2;
            }
            catch (Throwable throwable) {
                if (reloadScope != null) {
                    try {
                        reloadScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (reload != null) {
                reload.end();
            }
        }
    }

    public boolean cancel() {
        this.checkNotDryRun("cancel");
        ImplicitContextKeyed cancel = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            cancel = this.options.getOpenTelemetryTracer().spanBuilder("shaded.bqjdbc.com.google.cloud.bigquery.Job.cancel").startSpan();
        }
        try {
            Scope cancelScope = cancel != null ? cancel.makeCurrent() : null;
            try {
                boolean bl = this.bigquery.cancel(this.getJobId());
                if (cancelScope != null) {
                    cancelScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (cancelScope != null) {
                    try {
                        cancelScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (cancel != null) {
                cancel.end();
            }
        }
    }

    private void checkNotDryRun(String op) {
        Job.checkNotDryRun(this.getConfiguration(), op);
    }

    static void checkNotDryRun(JobConfiguration jobConfig, String op) {
        if (!(jobConfig instanceof QueryJobConfiguration)) {
            return;
        }
        QueryJobConfiguration config = (QueryJobConfiguration)jobConfig;
        Boolean dryRun = config.dryRun();
        if (dryRun == null) {
            dryRun = false;
        }
        if (dryRun.booleanValue()) {
            String msg = "Operation \"%s\" does not work for dryrun queries, since a dry run does not actually create a job. To validate a query and obtain some processing statistics, consider calling BigQuery.create(JobInfo).";
            throw new UnsupportedOperationException(String.format(msg, op));
        }
    }

    public BigQuery getBigQuery() {
        return this.bigquery;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Job.class)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals(this.options, other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.options);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bigquery = (BigQuery)this.options.getService();
    }

    static Job fromPb(BigQuery bigquery, shaded.bqjdbc.com.google.api.services.bigquery.model.Job jobPb) {
        return new Job(bigquery, new JobInfo.BuilderImpl(jobPb));
    }

    private static Attributes otelAttributesFromOptions(Option ... options) {
        Attributes attributes = Attributes.builder().build();
        for (Option option : options) {
            attributes = attributes.toBuilder().put(option.getRpcOption().toString(), option.getValue().toString()).build();
        }
        return attributes;
    }

    private static String getFieldAsString(Object field) {
        return field == null ? "null" : field.toString();
    }

    public static final class Builder
    extends JobInfo.Builder {
        private final BigQuery bigquery;
        private final JobInfo.BuilderImpl infoBuilder;

        Builder(BigQuery bigquery, JobConfiguration configuration) {
            this.bigquery = bigquery;
            this.infoBuilder = new JobInfo.BuilderImpl();
            this.infoBuilder.setConfiguration(configuration);
        }

        Builder(Job job) {
            this.bigquery = job.bigquery;
            this.infoBuilder = new JobInfo.BuilderImpl(job);
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        public Builder setJobId(JobId jobId) {
            this.infoBuilder.setJobId(jobId);
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        Builder setStatus(JobStatus status) {
            this.infoBuilder.setStatus(status);
            return this;
        }

        @Override
        Builder setStatistics(JobStatistics statistics) {
            this.infoBuilder.setStatistics(statistics);
            return this;
        }

        @Override
        Builder setUserEmail(String userEmail) {
            this.infoBuilder.setUserEmail(userEmail);
            return this;
        }

        @Override
        public Builder setConfiguration(JobConfiguration configuration) {
            this.infoBuilder.setConfiguration(configuration);
            return this;
        }

        @Override
        public Job build() {
            return new Job(this.bigquery, this.infoBuilder);
        }
    }
}

