/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.io.Serializable;
import java.util.Objects;
import shaded.bqjdbc.com.google.api.services.bigquery.model.ModelReference;
import shaded.bqjdbc.com.google.common.base.Function;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.base.Strings;
import shaded.bqjdbc.io.opentelemetry.api.common.Attributes;

public final class ModelId
implements Serializable {
    static final Function<ModelReference, ModelId> FROM_PB_FUNCTION = new Function<ModelReference, ModelId>(){

        @Override
        public ModelId apply(ModelReference pb) {
            return ModelId.fromPb(pb);
        }
    };
    static final Function<ModelId, ModelReference> TO_PB_FUNCTION = new Function<ModelId, ModelReference>(){

        @Override
        public ModelReference apply(ModelId modelId) {
            return modelId.toPb();
        }
    };
    private final String project;
    private final String dataset;
    private final String model;

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getModel() {
        return this.model;
    }

    private ModelId(String project, String dataset, String model) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(dataset), "Provided dataset is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(model), "Provided model is null or empty");
        this.project = project;
        this.dataset = dataset;
        this.model = model;
    }

    public static ModelId of(String project, String dataset, String model) {
        return new ModelId(project, dataset, model);
    }

    public static ModelId of(String dataset, String model) {
        return new ModelId(null, dataset, model);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ModelId && Objects.equals(this.toPb(), ((ModelId)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.project, this.dataset, this.model);
    }

    public String toString() {
        return this.toPb().toString();
    }

    ModelId setProjectId(String projectId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(projectId), "Provided projectId is null or empty");
        return ModelId.of(projectId, this.getDataset(), this.getModel());
    }

    ModelReference toPb() {
        return new ModelReference().setProjectId(this.project).setDatasetId(this.dataset).setModelId(this.model);
    }

    static ModelId fromPb(ModelReference modelRef) {
        return new ModelId(modelRef.getProjectId(), modelRef.getDatasetId(), modelRef.getModelId());
    }

    protected Attributes getOtelAttributes() {
        return Attributes.builder().put("bq.model.project", this.getProject()).put("bq.model.dataset", this.getDataset()).put("bq.model.id", this.getModel()).build();
    }
}

