/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.util.ArrayList;
import java.util.List;
import shaded.bqjdbc.com.google.api.services.bigquery.model.Expr;
import shaded.bqjdbc.com.google.cloud.Binding;
import shaded.bqjdbc.com.google.cloud.Condition;
import shaded.bqjdbc.com.google.cloud.Policy;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;

class PolicyHelper {
    PolicyHelper() {
    }

    static Policy convertFromApiPolicy(shaded.bqjdbc.com.google.api.services.bigquery.model.Policy apiPolicy) {
        Policy.Builder policyBuilder = Policy.newBuilder();
        List<shaded.bqjdbc.com.google.api.services.bigquery.model.Binding> bindings = apiPolicy.getBindings();
        if (null != bindings) {
            ImmutableList.Builder coreBindings = ImmutableList.builder();
            Binding.Builder bindingBuilder = Binding.newBuilder();
            for (shaded.bqjdbc.com.google.api.services.bigquery.model.Binding binding : bindings) {
                bindingBuilder.setRole(binding.getRole());
                bindingBuilder.setMembers(binding.getMembers());
                if (binding.getCondition() != null) {
                    Condition.Builder conditionBuilder = Condition.newBuilder();
                    conditionBuilder.setTitle(binding.getCondition().getTitle());
                    conditionBuilder.setDescription(binding.getCondition().getDescription());
                    conditionBuilder.setExpression(binding.getCondition().getExpression());
                    bindingBuilder.setCondition(conditionBuilder.build());
                }
                coreBindings.add(bindingBuilder.build());
            }
            policyBuilder.setBindings((List<Binding>)((Object)coreBindings.build()));
        }
        if (null != apiPolicy.getVersion()) {
            policyBuilder.setVersion(apiPolicy.getVersion());
        }
        return policyBuilder.setEtag(apiPolicy.getEtag()).build();
    }

    static shaded.bqjdbc.com.google.api.services.bigquery.model.Policy convertToApiPolicy(Policy policy) {
        ArrayList<shaded.bqjdbc.com.google.api.services.bigquery.model.Binding> bindings = null;
        if (policy.getBindingsList().size() != 0) {
            bindings = new ArrayList<shaded.bqjdbc.com.google.api.services.bigquery.model.Binding>(policy.getBindingsList().size());
            for (Binding binding : policy.getBindingsList()) {
                shaded.bqjdbc.com.google.api.services.bigquery.model.Binding apiBinding = new shaded.bqjdbc.com.google.api.services.bigquery.model.Binding();
                apiBinding.setRole(binding.getRole());
                apiBinding.setMembers(new ArrayList<String>(binding.getMembers()));
                if (binding.getCondition() != null) {
                    Expr expr = new Expr();
                    expr.setTitle(binding.getCondition().getTitle());
                    expr.setDescription(binding.getCondition().getDescription());
                    expr.setExpression(binding.getCondition().getExpression());
                    apiBinding.setCondition(expr);
                }
                bindings.add(apiBinding);
            }
        }
        return new shaded.bqjdbc.com.google.api.services.bigquery.model.Policy().setBindings(bindings).setEtag(policy.getEtag()).setVersion(policy.getVersion());
    }
}

