/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import shaded.bqjdbc.com.google.api.services.bigquery.model.ExplainQueryStage;
import shaded.bqjdbc.com.google.api.services.bigquery.model.ExplainQueryStep;
import shaded.bqjdbc.com.google.common.base.Function;
import shaded.bqjdbc.com.google.common.base.MoreObjects;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.com.google.common.collect.Lists;

public class QueryStage
implements Serializable {
    static final Function<ExplainQueryStage, QueryStage> FROM_PB_FUNCTION = new Function<ExplainQueryStage, QueryStage>(){

        @Override
        public QueryStage apply(ExplainQueryStage pb) {
            return QueryStage.fromPb(pb);
        }
    };
    static final Function<QueryStage, ExplainQueryStage> TO_PB_FUNCTION = new Function<QueryStage, ExplainQueryStage>(){

        @Override
        public ExplainQueryStage apply(QueryStage stage) {
            return stage.toPb();
        }
    };
    private static final long serialVersionUID = -472281297327952320L;
    private final long completedParallelInputs;
    private final long computeMsAvg;
    private final long computeMsMax;
    private final double computeRatioAvg;
    private final double computeRatioMax;
    private final long endMs;
    private final long generatedId;
    private final List<Long> inputStages;
    private final String name;
    private final long parallelInputs;
    private final long readMsAvg;
    private final long readMsMax;
    private final double readRatioAvg;
    private final double readRatioMax;
    private final long recordsRead;
    private final long recordsWritten;
    private final long shuffleOutputBytes;
    private final long shuffleOutputBytesSpilled;
    private final List<QueryStep> steps;
    private final long startMs;
    private String status;
    private final long waitMsAvg;
    private final long waitMsMax;
    private final double waitRatioAvg;
    private final double waitRatioMax;
    private final long writeMsAvg;
    private final long writeMsMax;
    private final double writeRatioAvg;
    private final double writeRatioMax;
    private final long slotMs;

    QueryStage(Builder builder) {
        this.completedParallelInputs = builder.completedParallelInputs;
        this.computeMsAvg = builder.computeMsAvg;
        this.computeMsMax = builder.computeMsMax;
        this.computeRatioAvg = builder.computeRatioAvg;
        this.computeRatioMax = builder.computeRatioMax;
        this.endMs = builder.endMs;
        this.generatedId = builder.generatedId;
        this.inputStages = builder.inputStages;
        this.name = builder.name;
        this.parallelInputs = builder.parallelInputs;
        this.readMsAvg = builder.readMsAvg;
        this.readMsMax = builder.readMsMax;
        this.readRatioAvg = builder.readRatioAvg;
        this.readRatioMax = builder.readRatioMax;
        this.recordsRead = builder.recordsRead;
        this.recordsWritten = builder.recordsWritten;
        this.shuffleOutputBytes = builder.shuffleOutputBytes;
        this.shuffleOutputBytesSpilled = builder.shuffleOutputBytesSpilled;
        this.startMs = builder.startMs;
        this.status = builder.status;
        this.steps = builder.steps;
        this.waitMsAvg = builder.waitMsAvg;
        this.waitMsMax = builder.waitMsMax;
        this.waitRatioAvg = builder.waitRatioAvg;
        this.waitRatioMax = builder.waitRatioMax;
        this.writeMsAvg = builder.writeMsAvg;
        this.writeMsMax = builder.writeMsMax;
        this.writeRatioAvg = builder.writeRatioAvg;
        this.writeRatioMax = builder.writeRatioMax;
        this.slotMs = builder.slotMs;
    }

    public long getCompletedParallelInputs() {
        return this.completedParallelInputs;
    }

    public long getComputeMsAvg() {
        return this.computeMsAvg;
    }

    public long getComputeMsMax() {
        return this.computeMsMax;
    }

    public double getComputeRatioAvg() {
        return this.computeRatioAvg;
    }

    public double getComputeRatioMax() {
        return this.computeRatioMax;
    }

    public long getEndMs() {
        return this.endMs;
    }

    public long getGeneratedId() {
        return this.generatedId;
    }

    public List<Long> getInputStages() {
        return this.inputStages;
    }

    public String getName() {
        return this.name;
    }

    public long getParallelInputs() {
        return this.parallelInputs;
    }

    public long getReadMsAvg() {
        return this.readMsAvg;
    }

    public long getReadMsMax() {
        return this.readMsMax;
    }

    public double getReadRatioAvg() {
        return this.readRatioAvg;
    }

    public double getReadRatioMax() {
        return this.readRatioMax;
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }

    public long getRecordsWritten() {
        return this.recordsWritten;
    }

    public long getShuffleOutputBytes() {
        return this.shuffleOutputBytes;
    }

    public long getShuffleOutputBytesSpilled() {
        return this.shuffleOutputBytesSpilled;
    }

    public long getStartMs() {
        return this.startMs;
    }

    public String getStatus() {
        return this.status;
    }

    public List<QueryStep> getSteps() {
        return this.steps;
    }

    public long getWaitMsAvg() {
        return this.waitMsAvg;
    }

    public long getWaitMsMax() {
        return this.waitMsMax;
    }

    public double getWaitRatioAvg() {
        return this.waitRatioAvg;
    }

    public double getWaitRatioMax() {
        return this.waitRatioMax;
    }

    public long getWriteMsAvg() {
        return this.writeMsAvg;
    }

    public long getWriteMsMax() {
        return this.writeMsMax;
    }

    public double getWriteRatioAvg() {
        return this.writeRatioAvg;
    }

    public double getWriteRatioMax() {
        return this.writeRatioMax;
    }

    public long getSlotMs() {
        return this.slotMs;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("shaded.bqjdbc.completedParallelInputs", this.completedParallelInputs).add("shaded.bqjdbc.computeMsAvg", this.computeMsAvg).add("shaded.bqjdbc.computeMsMax", this.computeMsMax).add("shaded.bqjdbc.computeRatioAvg", this.computeRatioAvg).add("shaded.bqjdbc.computeRatioMax", this.computeRatioMax).add("endMs", this.endMs).add("generatedId", this.generatedId).add("inputStages", this.inputStages).add("name", this.name).add("parallelInputs", this.parallelInputs).add("readMsAvg", this.readMsAvg).add("readMsMax", this.readMsMax).add("readRatioAvg", this.readRatioAvg).add("readRatioMax", this.readRatioMax).add("recordsRead", this.recordsRead).add("recordsWritten", this.recordsWritten).add("shuffleOutputBytes", this.shuffleOutputBytes).add("shuffleOutputBytesSpilled", this.shuffleOutputBytesSpilled).add("startMs", this.startMs).add("status", this.status).add("steps", this.steps).add("waitMsAvg", this.waitMsAvg).add("waitMsMax", this.waitMsMax).add("waitRatioAvg", this.waitRatioAvg).add("waitRatioMax", this.waitRatioMax).add("writeMsAvg", this.writeMsAvg).add("writeMsMax", this.writeMsMax).add("writeRatioAvg", this.writeRatioAvg).add("writeRatioMax", this.writeRatioMax).add("slotMs", this.slotMs).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.completedParallelInputs, this.computeMsAvg, this.computeMsMax, this.computeRatioAvg, this.computeRatioMax, this.endMs, this.generatedId, this.inputStages, this.name, this.parallelInputs, this.readMsAvg, this.readMsMax, this.readRatioAvg, this.readRatioMax, this.recordsRead, this.recordsWritten, this.shuffleOutputBytes, this.shuffleOutputBytesSpilled, this.startMs, this.status, this.steps, this.waitMsAvg, this.waitMsMax, this.waitRatioAvg, this.waitRatioMax, this.writeMsAvg, this.writeMsMax, this.writeRatioAvg, this.writeRatioMax, this.slotMs);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(QueryStage.class)) {
            return false;
        }
        QueryStage other = (QueryStage)obj;
        return this.generatedId == other.generatedId && this.completedParallelInputs == other.completedParallelInputs && this.computeMsAvg == other.computeMsAvg && this.computeMsMax == other.computeMsMax && this.computeRatioAvg == other.computeRatioAvg && this.computeRatioMax == other.computeRatioMax && this.endMs == other.endMs && this.parallelInputs == other.parallelInputs && this.readMsAvg == other.readMsAvg && this.readMsMax == other.readMsMax && this.readRatioAvg == other.readRatioAvg && this.readRatioMax == other.readRatioMax && this.recordsRead == other.recordsRead && this.recordsWritten == other.recordsWritten && this.shuffleOutputBytes == other.shuffleOutputBytes && this.shuffleOutputBytesSpilled == other.shuffleOutputBytesSpilled && this.startMs == other.startMs && this.waitMsAvg == other.waitMsAvg && this.waitMsMax == other.waitMsMax && this.waitRatioAvg == other.waitRatioAvg && this.waitRatioMax == other.waitRatioMax && this.writeMsAvg == other.writeMsAvg && this.writeMsMax == other.writeMsMax && this.writeRatioAvg == other.writeRatioAvg && this.writeRatioMax == other.writeRatioMax && Objects.equals(this.steps, other.steps) && Objects.equals(this.name, other.name) && Objects.equals(this.status, other.status) && Objects.equals(this.inputStages, other.inputStages) && Objects.equals(this.slotMs, other.slotMs);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    ExplainQueryStage toPb() {
        ExplainQueryStage stagePb = new ExplainQueryStage().setCompletedParallelInputs(this.completedParallelInputs).setComputeMsAvg(this.computeMsAvg).setComputeMsMax(this.computeMsMax).setComputeRatioAvg(this.computeRatioAvg).setComputeRatioMax(this.computeRatioMax).setEndMs(this.endMs).setId(this.generatedId).setInputStages(this.inputStages).setName(this.name).setParallelInputs(this.parallelInputs).setReadMsAvg(this.readMsAvg).setReadMsMax(this.readMsMax).setReadRatioAvg(this.readRatioAvg).setReadRatioMax(this.readRatioMax).setRecordsRead(this.recordsRead).setRecordsWritten(this.recordsWritten).setShuffleOutputBytes(this.shuffleOutputBytes).setShuffleOutputBytesSpilled(this.shuffleOutputBytesSpilled).setStartMs(this.startMs).setStatus(this.status).setWaitMsAvg(this.waitMsAvg).setWaitMsMax(this.waitMsMax).setWaitRatioAvg(this.waitRatioAvg).setWaitRatioMax(this.waitRatioMax).setWriteMsAvg(this.writeMsAvg).setWriteMsMax(this.writeMsMax).setWriteRatioAvg(this.writeRatioAvg).setWriteRatioMax(this.writeRatioMax).setSlotMs(this.slotMs);
        if (this.steps != null) {
            stagePb.setSteps(Lists.transform(this.steps, QueryStep.TO_PB_FUNCTION));
        }
        return stagePb;
    }

    static QueryStage fromPb(ExplainQueryStage stagePb) {
        Builder builder = new Builder();
        builder.setCompletedParallelInputs(stagePb.getCompletedParallelInputs());
        builder.setComputeMsAvg(stagePb.getComputeMsAvg());
        builder.setComputeMsMax(stagePb.getComputeMsMax());
        builder.setComputeRatioAvg(stagePb.getComputeRatioAvg());
        builder.setComputeRatioMax(stagePb.getComputeRatioMax());
        builder.setEndMs(stagePb.getEndMs());
        builder.setGeneratedId(stagePb.getId());
        builder.setInputStages(stagePb.getInputStages());
        builder.setName(stagePb.getName());
        builder.setParallelInputs(stagePb.getParallelInputs());
        builder.setReadMsAvg(stagePb.getReadMsAvg());
        builder.setReadMsMax(stagePb.getReadMsMax());
        builder.setReadRatioAvg(stagePb.getReadRatioAvg());
        builder.setReadRatioMax(stagePb.getReadRatioMax());
        builder.setRecordsRead(stagePb.getRecordsRead());
        builder.setRecordsWritten(stagePb.getRecordsWritten());
        builder.setShuffleOutputBytes(stagePb.getShuffleOutputBytes());
        builder.setShuffleOutputBytesSpilled(stagePb.getShuffleOutputBytesSpilled());
        builder.setStartMs(stagePb.getStartMs());
        builder.setStatus(stagePb.getStatus());
        if (stagePb.getSteps() != null) {
            builder.setSteps(Lists.transform(stagePb.getSteps(), QueryStep.FROM_PB_FUNCTION));
        }
        builder.setWaitMsAvg(stagePb.getWaitMsAvg());
        builder.setWaitMsMax(stagePb.getWaitMsMax());
        builder.setWaitRatioAvg(stagePb.getWaitRatioAvg());
        builder.setWaitRatioMax(stagePb.getWaitRatioMax());
        builder.setWriteMsAvg(stagePb.getWriteMsAvg());
        builder.setWriteMsMax(stagePb.getWriteMsMax());
        builder.setWriteRatioAvg(stagePb.getWriteRatioAvg());
        builder.setWriteRatioMax(stagePb.getWriteRatioMax());
        builder.setSlotMs(stagePb.getSlotMs());
        return builder.build();
    }

    static final class Builder {
        private long completedParallelInputs;
        private long computeMsAvg;
        private long computeMsMax;
        private double computeRatioAvg;
        private double computeRatioMax;
        private long endMs;
        private long generatedId;
        private List<Long> inputStages;
        private String name;
        private long parallelInputs;
        private long readMsAvg;
        private long readMsMax;
        private double readRatioAvg;
        private double readRatioMax;
        private long recordsRead;
        private long recordsWritten;
        private long shuffleOutputBytes;
        private long shuffleOutputBytesSpilled;
        private long startMs;
        private String status;
        private List<QueryStep> steps;
        private long waitMsAvg;
        private long waitMsMax;
        private double waitRatioAvg;
        private double waitRatioMax;
        private long writeMsAvg;
        private long writeMsMax;
        private double writeRatioAvg;
        private double writeRatioMax;
        private long slotMs;

        private Builder() {
        }

        Builder setCompletedParallelInputs(long completedParallelInputs) {
            this.completedParallelInputs = completedParallelInputs;
            return this;
        }

        Builder setComputeMsAvg(long computeMsAvg) {
            this.computeMsAvg = computeMsAvg;
            return this;
        }

        Builder setComputeMsMax(long computeMsMax) {
            this.computeMsMax = computeMsMax;
            return this;
        }

        Builder setComputeRatioAvg(double computeRatioAvg) {
            this.computeRatioAvg = computeRatioAvg;
            return this;
        }

        Builder setComputeRatioMax(double computeRatioMax) {
            this.computeRatioMax = computeRatioMax;
            return this;
        }

        Builder setEndMs(long endMs) {
            this.endMs = endMs;
            return this;
        }

        Builder setGeneratedId(long generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder setInputStages(List<Long> inputStages) {
            this.inputStages = inputStages;
            return this;
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        Builder setParallelInputs(long parallelInputs) {
            this.parallelInputs = parallelInputs;
            return this;
        }

        Builder setReadMsAvg(long readMsAvg) {
            this.readMsAvg = readMsAvg;
            return this;
        }

        Builder setReadMsMax(long readMsMax) {
            this.readMsMax = readMsMax;
            return this;
        }

        Builder setReadRatioAvg(double readRatioAvg) {
            this.readRatioAvg = readRatioAvg;
            return this;
        }

        Builder setReadRatioMax(double readRatioMax) {
            this.readRatioMax = readRatioMax;
            return this;
        }

        Builder setRecordsRead(long recordsRead) {
            this.recordsRead = recordsRead;
            return this;
        }

        Builder setRecordsWritten(long recordsWritten) {
            this.recordsWritten = recordsWritten;
            return this;
        }

        Builder setShuffleOutputBytes(long shuffleOutputBytes) {
            this.shuffleOutputBytes = shuffleOutputBytes;
            return this;
        }

        Builder setShuffleOutputBytesSpilled(long shuffleOutputBytesSpilled) {
            this.shuffleOutputBytesSpilled = shuffleOutputBytesSpilled;
            return this;
        }

        Builder setStartMs(long startMs) {
            this.startMs = startMs;
            return this;
        }

        Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        Builder setSteps(List<QueryStep> steps) {
            this.steps = steps;
            return this;
        }

        Builder setWaitMsAvg(long waitMsAvg) {
            this.waitMsAvg = waitMsAvg;
            return this;
        }

        Builder setWaitMsMax(long waitMsMax) {
            this.waitMsMax = waitMsMax;
            return this;
        }

        Builder setWaitRatioAvg(double waitRatioAvg) {
            this.waitRatioAvg = waitRatioAvg;
            return this;
        }

        Builder setWaitRatioMax(double waitRatioMax) {
            this.waitRatioMax = waitRatioMax;
            return this;
        }

        Builder setWriteMsAvg(long writeMsAvg) {
            this.writeMsAvg = writeMsAvg;
            return this;
        }

        Builder setWriteMsMax(long writeMsMax) {
            this.writeMsMax = writeMsMax;
            return this;
        }

        Builder setWriteRatioAvg(double writeRatioAvg) {
            this.writeRatioAvg = writeRatioAvg;
            return this;
        }

        Builder setWriteRatioMax(double writeRatioMax) {
            this.writeRatioMax = writeRatioMax;
            return this;
        }

        Builder setSlotMs(long slotMs) {
            this.slotMs = slotMs;
            return this;
        }

        QueryStage build() {
            return new QueryStage(this);
        }
    }

    public static class QueryStep
    implements Serializable {
        static final Function<ExplainQueryStep, QueryStep> FROM_PB_FUNCTION = new Function<ExplainQueryStep, QueryStep>(){

            @Override
            public QueryStep apply(ExplainQueryStep pb) {
                return QueryStep.fromPb(pb);
            }
        };
        static final Function<QueryStep, ExplainQueryStep> TO_PB_FUNCTION = new Function<QueryStep, ExplainQueryStep>(){

            @Override
            public ExplainQueryStep apply(QueryStep stage) {
                return stage.toPb();
            }
        };
        private static final long serialVersionUID = 8663444604771794411L;
        private final String name;
        private final List<String> substeps;

        QueryStep(String name, List<String> substeps) {
            this.name = name;
            this.substeps = substeps;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getSubsteps() {
            return this.substeps;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("substeps", this.substeps).toString();
        }

        public int hashCode() {
            return Objects.hash(this.name, this.substeps);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof QueryStep)) {
                return false;
            }
            QueryStep other = (QueryStep)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.substeps, other.substeps);
        }

        ExplainQueryStep toPb() {
            return new ExplainQueryStep().setKind(this.name).setSubsteps(this.substeps);
        }

        static QueryStep fromPb(ExplainQueryStep stepPb) {
            return new QueryStep(stepPb.getKind(), ImmutableList.copyOf(stepPb.getSubsteps() != null ? stepPb.getSubsteps() : ImmutableList.of()));
        }
    }
}

