/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.api.services.bigquery.model.Streamingbuffer;
import shaded.bqjdbc.com.google.api.services.bigquery.model.Table;
import shaded.bqjdbc.com.google.auto.value.AutoValue;
import shaded.bqjdbc.com.google.cloud.bigquery.AutoValue_StandardTableDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.BigLakeConfiguration;
import shaded.bqjdbc.com.google.cloud.bigquery.Clustering;
import shaded.bqjdbc.com.google.cloud.bigquery.RangePartitioning;
import shaded.bqjdbc.com.google.cloud.bigquery.Schema;
import shaded.bqjdbc.com.google.cloud.bigquery.TableConstraints;
import shaded.bqjdbc.com.google.cloud.bigquery.TableDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.TimePartitioning;
import shaded.bqjdbc.com.google.common.base.MoreObjects;

@AutoValue
public abstract class StandardTableDefinition
extends TableDefinition {
    private static final long serialVersionUID = 2113445776046717900L;

    @Nullable
    public abstract Long getNumBytes();

    @Nullable
    public abstract Long getNumLongTermBytes();

    @Nullable
    public abstract Long getNumTimeTravelPhysicalBytes();

    @Nullable
    public abstract Long getNumTotalLogicalBytes();

    @Nullable
    public abstract Long getNumActiveLogicalBytes();

    @Nullable
    public abstract Long getNumLongTermLogicalBytes();

    @Nullable
    public abstract Long getNumTotalPhysicalBytes();

    @Nullable
    public abstract Long getNumActivePhysicalBytes();

    @Nullable
    public abstract Long getNumLongTermPhysicalBytes();

    @Nullable
    public abstract Long getNumRows();

    @Nullable
    public abstract String getLocation();

    @Nullable
    public abstract StreamingBuffer getStreamingBuffer();

    @Nullable
    public abstract TimePartitioning getTimePartitioning();

    @Nullable
    public abstract RangePartitioning getRangePartitioning();

    @Nullable
    public abstract Clustering getClustering();

    @Nullable
    public abstract TableConstraints getTableConstraints();

    @Nullable
    public abstract BigLakeConfiguration getBigLakeConfiguration();

    public static Builder newBuilder() {
        return new AutoValue_StandardTableDefinition.Builder().setType(TableDefinition.Type.TABLE);
    }

    public static StandardTableDefinition of(Schema schema) {
        return StandardTableDefinition.newBuilder().setSchema(schema).build();
    }

    @Override
    public abstract Builder toBuilder();

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        if (this.getNumRows() != null) {
            tablePb.setNumRows(BigInteger.valueOf(this.getNumRows()));
        }
        tablePb.setNumBytes(this.getNumBytes());
        tablePb.setNumLongTermBytes(this.getNumLongTermBytes());
        tablePb.setNumTimeTravelPhysicalBytes(this.getNumTimeTravelPhysicalBytes());
        tablePb.setNumTotalLogicalBytes(this.getNumTotalLogicalBytes());
        tablePb.setNumActiveLogicalBytes(this.getNumActiveLogicalBytes());
        tablePb.setNumLongTermLogicalBytes(this.getNumLongTermLogicalBytes());
        tablePb.setNumTotalPhysicalBytes(this.getNumTotalPhysicalBytes());
        tablePb.setNumActivePhysicalBytes(this.getNumActivePhysicalBytes());
        tablePb.setNumLongTermPhysicalBytes(this.getNumLongTermPhysicalBytes());
        tablePb.setLocation(this.getLocation());
        if (this.getStreamingBuffer() != null) {
            tablePb.setStreamingBuffer(this.getStreamingBuffer().toPb());
        }
        if (this.getTimePartitioning() != null) {
            tablePb.setTimePartitioning(this.getTimePartitioning().toPb());
        }
        if (this.getRangePartitioning() != null) {
            tablePb.setRangePartitioning(this.getRangePartitioning().toPb());
        }
        if (this.getClustering() != null) {
            tablePb.setClustering(this.getClustering().toPb());
        }
        if (this.getTableConstraints() != null) {
            tablePb.setTableConstraints(this.getTableConstraints().toPb());
        }
        if (this.getBigLakeConfiguration() != null) {
            tablePb.setBiglakeConfiguration(this.getBigLakeConfiguration().toPb());
        }
        return tablePb;
    }

    static StandardTableDefinition fromPb(Table tablePb) {
        Builder builder = (Builder)StandardTableDefinition.newBuilder().table(tablePb);
        if (tablePb.getNumRows() != null) {
            builder.setNumRows(tablePb.getNumRows().longValue());
        }
        if (tablePb.getStreamingBuffer() != null) {
            builder.setStreamingBuffer(StreamingBuffer.fromPb(tablePb.getStreamingBuffer()));
        }
        if (tablePb.getTimePartitioning() != null) {
            try {
                builder.setTimePartitioning(TimePartitioning.fromPb(tablePb.getTimePartitioning()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal Argument - Got unexpected time partitioning " + tablePb.getTimePartitioning().getType() + " in project " + tablePb.getTableReference().getProjectId() + " in dataset " + tablePb.getTableReference().getDatasetId() + " in table " + tablePb.getTableReference().getTableId(), e);
            }
        }
        if (tablePb.getRangePartitioning() != null) {
            builder.setRangePartitioning(RangePartitioning.fromPb(tablePb.getRangePartitioning()));
        }
        if (tablePb.getClustering() != null) {
            builder.setClustering(Clustering.fromPb(tablePb.getClustering()));
        }
        if (tablePb.getNumLongTermBytes() != null) {
            builder.setNumLongTermBytes(tablePb.getNumLongTermBytes());
        }
        if (tablePb.getNumTimeTravelPhysicalBytes() != null) {
            builder.setNumTimeTravelPhysicalBytes(tablePb.getNumTimeTravelPhysicalBytes());
        }
        if (tablePb.getNumTotalLogicalBytes() != null) {
            builder.setNumTotalLogicalBytes(tablePb.getNumTotalLogicalBytes());
        }
        if (tablePb.getNumActiveLogicalBytes() != null) {
            builder.setNumActiveLogicalBytes(tablePb.getNumActiveLogicalBytes());
        }
        if (tablePb.getNumLongTermLogicalBytes() != null) {
            builder.setNumLongTermLogicalBytes(tablePb.getNumLongTermLogicalBytes());
        }
        if (tablePb.getNumTotalPhysicalBytes() != null) {
            builder.setNumTotalPhysicalBytes(tablePb.getNumTotalPhysicalBytes());
        }
        if (tablePb.getNumActivePhysicalBytes() != null) {
            builder.setNumActivePhysicalBytes(tablePb.getNumActivePhysicalBytes());
        }
        if (tablePb.getNumLongTermPhysicalBytes() != null) {
            builder.setNumLongTermPhysicalBytes(tablePb.getNumLongTermPhysicalBytes());
        }
        if (tablePb.getTableConstraints() != null) {
            builder.setTableConstraints(TableConstraints.fromPb(tablePb.getTableConstraints()));
        }
        if (tablePb.getBiglakeConfiguration() != null) {
            builder.setBigLakeConfiguration(BigLakeConfiguration.fromPb(tablePb.getBiglakeConfiguration()));
        }
        return builder.setNumBytes(tablePb.getNumBytes()).setLocation(tablePb.getLocation()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends TableDefinition.Builder<StandardTableDefinition, Builder> {
        public abstract Builder setNumBytes(Long var1);

        public abstract Builder setNumLongTermBytes(Long var1);

        public abstract Builder setNumTimeTravelPhysicalBytes(Long var1);

        public abstract Builder setNumTotalLogicalBytes(Long var1);

        public abstract Builder setNumActiveLogicalBytes(Long var1);

        public abstract Builder setNumLongTermLogicalBytes(Long var1);

        public abstract Builder setNumTotalPhysicalBytes(Long var1);

        public abstract Builder setNumActivePhysicalBytes(Long var1);

        public abstract Builder setNumLongTermPhysicalBytes(Long var1);

        public abstract Builder setNumRows(Long var1);

        public abstract Builder setLocation(String var1);

        public abstract Builder setStreamingBuffer(StreamingBuffer var1);

        @Override
        public abstract Builder setType(TableDefinition.Type var1);

        @Override
        public abstract Builder setSchema(Schema var1);

        public abstract Builder setTimePartitioning(TimePartitioning var1);

        public abstract Builder setRangePartitioning(RangePartitioning var1);

        public abstract Builder setClustering(Clustering var1);

        public abstract Builder setTableConstraints(TableConstraints var1);

        public abstract Builder setBigLakeConfiguration(BigLakeConfiguration var1);

        @Override
        public abstract StandardTableDefinition build();
    }

    public static class StreamingBuffer
    implements Serializable {
        private static final long serialVersionUID = 822027055549277843L;
        private final Long estimatedRows;
        private final Long estimatedBytes;
        private final Long oldestEntryTime;

        StreamingBuffer(Long estimatedRows, Long estimatedBytes, Long oldestEntryTime) {
            this.estimatedRows = estimatedRows;
            this.estimatedBytes = estimatedBytes;
            this.oldestEntryTime = oldestEntryTime;
        }

        public Long getEstimatedRows() {
            return this.estimatedRows;
        }

        public Long getEstimatedBytes() {
            return this.estimatedBytes;
        }

        public Long getOldestEntryTime() {
            return this.oldestEntryTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("estimatedRows", this.estimatedRows).add("estimatedBytes", this.estimatedBytes).add("oldestEntryTime", this.oldestEntryTime).toString();
        }

        public int hashCode() {
            return Objects.hash(this.estimatedRows, this.estimatedBytes, this.oldestEntryTime);
        }

        public boolean equals(Object obj) {
            return obj instanceof StreamingBuffer && Objects.equals(this.toPb(), ((StreamingBuffer)obj).toPb());
        }

        Streamingbuffer toPb() {
            Streamingbuffer buffer = new Streamingbuffer();
            if (this.estimatedBytes != null) {
                buffer.setEstimatedBytes(BigInteger.valueOf(this.estimatedBytes));
            }
            if (this.estimatedRows != null) {
                buffer.setEstimatedRows(BigInteger.valueOf(this.estimatedRows));
            }
            if (this.oldestEntryTime != null) {
                buffer.setOldestEntryTime(BigInteger.valueOf(this.oldestEntryTime));
            }
            return buffer;
        }

        static StreamingBuffer fromPb(Streamingbuffer streamingBufferPb) {
            Long oldestEntryTime = null;
            if (streamingBufferPb.getOldestEntryTime() != null) {
                oldestEntryTime = streamingBufferPb.getOldestEntryTime().longValue();
            }
            return new StreamingBuffer(streamingBufferPb.getEstimatedRows() != null ? Long.valueOf(streamingBufferPb.getEstimatedRows().longValue()) : null, streamingBufferPb.getEstimatedBytes() != null ? Long.valueOf(streamingBufferPb.getEstimatedBytes().longValue()) : null, oldestEntryTime);
        }
    }
}

