/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.io.Serializable;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.api.core.ApiFunction;
import shaded.bqjdbc.com.google.api.services.bigquery.model.Table;
import shaded.bqjdbc.com.google.cloud.StringEnumType;
import shaded.bqjdbc.com.google.cloud.StringEnumValue;
import shaded.bqjdbc.com.google.cloud.bigquery.ExternalTableDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.MaterializedViewDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.ModelTableDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.Schema;
import shaded.bqjdbc.com.google.cloud.bigquery.SnapshotTableDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardTableDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.ViewDefinition;

public abstract class TableDefinition
implements Serializable {
    private static final long serialVersionUID = -374760330662959529L;

    public abstract Type getType();

    @Nullable
    public abstract Schema getSchema();

    public abstract Builder toBuilder();

    Table toPb() {
        Table tablePb = new Table();
        if (this.getSchema() != null) {
            tablePb.setSchema(this.getSchema().toPb());
        }
        tablePb.setType(this.getType().name());
        return tablePb;
    }

    static <T extends TableDefinition> T fromPb(Table tablePb) {
        switch (Type.valueOf(tablePb.getType()).toString()) {
            case "TABLE": {
                return (T)StandardTableDefinition.fromPb(tablePb);
            }
            case "VIEW": {
                return (T)ViewDefinition.fromPb(tablePb);
            }
            case "MATERIALIZED_VIEW": {
                return (T)MaterializedViewDefinition.fromPb(tablePb);
            }
            case "EXTERNAL": {
                return (T)ExternalTableDefinition.fromPb(tablePb);
            }
            case "MODEL": {
                return (T)ModelTableDefinition.fromPb(tablePb);
            }
            case "SNAPSHOT": {
                return (T)SnapshotTableDefinition.fromPb(tablePb);
            }
        }
        throw new IllegalArgumentException("Format " + tablePb.getType() + " is not supported");
    }

    public static final class Type
    extends StringEnumValue {
        private static final long serialVersionUID = -551560816480511474L;
        private static final ApiFunction<String, Type> CONSTRUCTOR = new ApiFunction<String, Type>(){

            @Override
            public Type apply(String constant) {
                return new Type(constant);
            }
        };
        private static final StringEnumType<Type> type = new StringEnumType<Type>(Type.class, CONSTRUCTOR);
        public static final Type TABLE = type.createAndRegister("TABLE");
        public static final Type VIEW = type.createAndRegister("VIEW");
        public static final Type MATERIALIZED_VIEW = type.createAndRegister("MATERIALIZED_VIEW");
        public static final Type EXTERNAL = type.createAndRegister("EXTERNAL");
        public static final Type MODEL = type.createAndRegister("MODEL");
        public static final Type SNAPSHOT = type.createAndRegister("SNAPSHOT");

        private Type(String constant) {
            super(constant);
        }

        public static Type valueOfStrict(String constant) {
            return type.valueOfStrict(constant);
        }

        public static Type valueOf(String constant) {
            return type.valueOf(constant);
        }

        public static Type[] values() {
            return type.values();
        }
    }

    public static abstract class Builder<T extends TableDefinition, B extends Builder<T, B>> {
        public abstract B setType(Type var1);

        public abstract B setSchema(Schema var1);

        public abstract T build();

        B table(Table tablePb) {
            if (tablePb.getSchema() != null) {
                this.setSchema(Schema.fromPb(tablePb.getSchema()));
            }
            return this.setType(Type.valueOf(tablePb.getType()));
        }
    }
}

