/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery;

import java.util.List;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.api.services.bigquery.model.Table;
import shaded.bqjdbc.com.google.auto.value.AutoValue;
import shaded.bqjdbc.com.google.cloud.bigquery.AutoValue_ViewDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.Schema;
import shaded.bqjdbc.com.google.cloud.bigquery.TableDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.UserDefinedFunction;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.com.google.common.collect.Lists;

@AutoValue
public abstract class ViewDefinition
extends TableDefinition {
    private static final long serialVersionUID = -8789311196910794545L;

    @Nullable
    public abstract String getQuery();

    public List<UserDefinedFunction> getUserDefinedFunctions() {
        return this.getUserDefinedFunctionsImmut();
    }

    @Nullable
    abstract ImmutableList<UserDefinedFunction> getUserDefinedFunctionsImmut();

    @Nullable
    public Boolean useLegacySql() {
        return this.getUseLegacySql();
    }

    @Nullable
    abstract Boolean getUseLegacySql();

    @Override
    public abstract Builder toBuilder();

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        shaded.bqjdbc.com.google.api.services.bigquery.model.ViewDefinition viewDefinition = new shaded.bqjdbc.com.google.api.services.bigquery.model.ViewDefinition().setQuery(this.getQuery());
        if (this.getUserDefinedFunctions() != null) {
            viewDefinition.setUserDefinedFunctionResources(Lists.transform(this.getUserDefinedFunctions(), UserDefinedFunction.TO_PB_FUNCTION));
        }
        viewDefinition.setUseLegacySql(this.useLegacySql());
        tablePb.setView(viewDefinition);
        return tablePb;
    }

    static Builder newBuilder() {
        return new AutoValue_ViewDefinition.Builder().setType(TableDefinition.Type.VIEW).setUseLegacySql(false);
    }

    public static Builder newBuilder(String query) {
        return ViewDefinition.newBuilder().setQuery(query);
    }

    public static Builder newBuilder(String query, List<UserDefinedFunction> functions) {
        return ViewDefinition.newBuilder(query).setUserDefinedFunctions(functions);
    }

    public static Builder newBuilder(String query, UserDefinedFunction ... functions) {
        return ViewDefinition.newBuilder(query).setUserDefinedFunctions(functions);
    }

    public static ViewDefinition of(String query) {
        return ViewDefinition.newBuilder(query).build();
    }

    public static ViewDefinition of(String query, List<UserDefinedFunction> functions) {
        return ViewDefinition.newBuilder(query, functions).build();
    }

    public static ViewDefinition of(String query, UserDefinedFunction ... functions) {
        return ViewDefinition.newBuilder(query, functions).build();
    }

    static ViewDefinition fromPb(Table tablePb) {
        Builder builder = (Builder)ViewDefinition.newBuilder().table(tablePb);
        shaded.bqjdbc.com.google.api.services.bigquery.model.ViewDefinition viewPb = tablePb.getView();
        if (viewPb != null) {
            builder.setQuery(viewPb.getQuery()).setUseLegacySql(viewPb.getUseLegacySql());
            if (viewPb.getUserDefinedFunctionResources() != null) {
                builder.setUserDefinedFunctions(Lists.transform(viewPb.getUserDefinedFunctionResources(), UserDefinedFunction.FROM_PB_FUNCTION));
            }
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends TableDefinition.Builder<ViewDefinition, Builder> {
        public abstract Builder setQuery(String var1);

        public Builder setUserDefinedFunctions(List<UserDefinedFunction> userDefinedFunctions) {
            return this.setUserDefinedFunctionsImmut(ImmutableList.copyOf(userDefinedFunctions));
        }

        public Builder setUserDefinedFunctions(UserDefinedFunction ... userDefinedFunctions) {
            return this.setUserDefinedFunctionsImmut(ImmutableList.copyOf(userDefinedFunctions));
        }

        abstract Builder setUserDefinedFunctionsImmut(ImmutableList<UserDefinedFunction> var1);

        public abstract Builder setUseLegacySql(Boolean var1);

        @Override
        public abstract Builder setType(TableDefinition.Type var1);

        @Override
        public abstract Builder setSchema(Schema var1);

        @Override
        public abstract ViewDefinition build();
    }
}

