/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery.storage.v1;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import shaded.bqjdbc.com.google.api.gax.core.BackgroundResource;
import shaded.bqjdbc.com.google.api.gax.rpc.BidiStreamingCallable;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallable;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.FlushRowsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.TableName;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.WriteStream;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.WriteStreamName;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.stub.BigQueryWriteStub;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.stub.BigQueryWriteStubSettings;

public class BigQueryWriteClient
implements BackgroundResource {
    private final BigQueryWriteSettings settings;
    private final BigQueryWriteStub stub;

    public static final BigQueryWriteClient create() throws IOException {
        return BigQueryWriteClient.create(BigQueryWriteSettings.newBuilder().build());
    }

    public static final BigQueryWriteClient create(BigQueryWriteSettings settings) throws IOException {
        return new BigQueryWriteClient(settings);
    }

    public static final BigQueryWriteClient create(BigQueryWriteStub stub) {
        return new BigQueryWriteClient(stub);
    }

    protected BigQueryWriteClient(BigQueryWriteSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigQueryWriteStubSettings)settings.getStubSettings()).createStub();
    }

    protected BigQueryWriteClient(BigQueryWriteStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BigQueryWriteSettings getSettings() {
        return this.settings;
    }

    public BigQueryWriteStub getStub() {
        return this.stub;
    }

    public final WriteStream createWriteStream(TableName parent, WriteStream writeStream) {
        CreateWriteStreamRequest request = CreateWriteStreamRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWriteStream(writeStream).build();
        return this.createWriteStream(request);
    }

    public final WriteStream createWriteStream(String parent, WriteStream writeStream) {
        CreateWriteStreamRequest request = CreateWriteStreamRequest.newBuilder().setParent(parent).setWriteStream(writeStream).build();
        return this.createWriteStream(request);
    }

    public final WriteStream createWriteStream(CreateWriteStreamRequest request) {
        return this.createWriteStreamCallable().call(request);
    }

    public final UnaryCallable<CreateWriteStreamRequest, WriteStream> createWriteStreamCallable() {
        return this.stub.createWriteStreamCallable();
    }

    public final BidiStreamingCallable<AppendRowsRequest, AppendRowsResponse> appendRowsCallable() {
        return this.stub.appendRowsCallable();
    }

    public final WriteStream getWriteStream(WriteStreamName name) {
        GetWriteStreamRequest request = GetWriteStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWriteStream(request);
    }

    public final WriteStream getWriteStream(String name) {
        GetWriteStreamRequest request = GetWriteStreamRequest.newBuilder().setName(name).build();
        return this.getWriteStream(request);
    }

    public final WriteStream getWriteStream(GetWriteStreamRequest request) {
        return this.getWriteStreamCallable().call(request);
    }

    public final UnaryCallable<GetWriteStreamRequest, WriteStream> getWriteStreamCallable() {
        return this.stub.getWriteStreamCallable();
    }

    public final FinalizeWriteStreamResponse finalizeWriteStream(WriteStreamName name) {
        FinalizeWriteStreamRequest request = FinalizeWriteStreamRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.finalizeWriteStream(request);
    }

    public final FinalizeWriteStreamResponse finalizeWriteStream(String name) {
        FinalizeWriteStreamRequest request = FinalizeWriteStreamRequest.newBuilder().setName(name).build();
        return this.finalizeWriteStream(request);
    }

    public final FinalizeWriteStreamResponse finalizeWriteStream(FinalizeWriteStreamRequest request) {
        return this.finalizeWriteStreamCallable().call(request);
    }

    public final UnaryCallable<FinalizeWriteStreamRequest, FinalizeWriteStreamResponse> finalizeWriteStreamCallable() {
        return this.stub.finalizeWriteStreamCallable();
    }

    public final BatchCommitWriteStreamsResponse batchCommitWriteStreams(TableName parent) {
        BatchCommitWriteStreamsRequest request = BatchCommitWriteStreamsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.batchCommitWriteStreams(request);
    }

    public final BatchCommitWriteStreamsResponse batchCommitWriteStreams(String parent) {
        BatchCommitWriteStreamsRequest request = BatchCommitWriteStreamsRequest.newBuilder().setParent(parent).build();
        return this.batchCommitWriteStreams(request);
    }

    public final BatchCommitWriteStreamsResponse batchCommitWriteStreams(BatchCommitWriteStreamsRequest request) {
        return this.batchCommitWriteStreamsCallable().call(request);
    }

    public final UnaryCallable<BatchCommitWriteStreamsRequest, BatchCommitWriteStreamsResponse> batchCommitWriteStreamsCallable() {
        return this.stub.batchCommitWriteStreamsCallable();
    }

    public final FlushRowsResponse flushRows(WriteStreamName writeStream) {
        FlushRowsRequest request = FlushRowsRequest.newBuilder().setWriteStream(writeStream == null ? null : writeStream.toString()).build();
        return this.flushRows(request);
    }

    public final FlushRowsResponse flushRows(String writeStream) {
        FlushRowsRequest request = FlushRowsRequest.newBuilder().setWriteStream(writeStream).build();
        return this.flushRows(request);
    }

    public final FlushRowsResponse flushRows(FlushRowsRequest request) {
        return this.flushRowsCallable().call(request);
    }

    public final UnaryCallable<FlushRowsRequest, FlushRowsResponse> flushRowsCallable() {
        return this.stub.flushRowsCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

