/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery.storage.v1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.api.core.ApiFuture;
import shaded.bqjdbc.com.google.api.gax.batching.FlowController;
import shaded.bqjdbc.com.google.api.gax.core.CredentialsProvider;
import shaded.bqjdbc.com.google.api.gax.core.ExecutorProvider;
import shaded.bqjdbc.com.google.api.gax.core.GaxProperties;
import shaded.bqjdbc.com.google.api.gax.retrying.RetrySettings;
import shaded.bqjdbc.com.google.api.gax.rpc.TransportChannelProvider;
import shaded.bqjdbc.com.google.auth.Credentials;
import shaded.bqjdbc.com.google.auto.value.AutoOneOf;
import shaded.bqjdbc.com.google.auto.value.AutoValue;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.AppendFormats;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ArrowRecordBatch;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ArrowSchema;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.AutoOneOf_StreamWriter_SingleConnectionOrConnectionPool;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.AutoValue_StreamWriter_ConnectionPoolKey;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ConnectionWorker;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ConnectionWorkerPool;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.Exceptions;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ProtoRows;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ProtoSchema;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.RequestProfiler;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.TableName;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.TableSchema;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.WriteStream;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.WriteStreamView;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.cache.Cache;
import shaded.bqjdbc.com.google.common.cache.CacheBuilder;
import shaded.bqjdbc.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shaded.bqjdbc.com.google.protobuf.ByteString;
import shaded.bqjdbc.io.grpc.Status;
import shaded.bqjdbc.io.grpc.StatusRuntimeException;
import shaded.bqjdbc.io.opentelemetry.api.common.Attributes;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.WriteChannel;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.message.MessageSerializer;
import shaded.bqjdbc.org.apache.arrow.vector.types.pojo.Schema;

public class StreamWriter
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(StreamWriter.class.getName());
    private static String datasetsMatching = "projects/[^/]+/datasets/[^/]+/";
    private static Pattern streamPatternDatasets = Pattern.compile(datasetsMatching);
    private static String defaultStreamMatching = "/_default";
    private static Pattern streamPatternDefaultStream = Pattern.compile(defaultStreamMatching);
    private static long LOCATION_CACHE_EXPIRE_MILLIS = 600000L;
    private static Cache<String, String> projectAndDatasetToLocation = StreamWriter.allocateProjectLocationCache();
    private final String streamName;
    private final String fullTraceId;
    private final AppendFormats.AppendRowsSchema writerSchema;
    private final String location;
    private AtomicBoolean userClosed = new AtomicBoolean(false);
    private final String writerId = UUID.randomUUID().toString();
    private AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation = AppendRowsRequest.MissingValueInterpretation.MISSING_VALUE_INTERPRETATION_UNSPECIFIED;
    private Map<String, AppendRowsRequest.MissingValueInterpretation> missingValueInterpretationMap = new HashMap<String, AppendRowsRequest.MissingValueInterpretation>();
    private final SingleConnectionOrConnectionPool singleConnectionOrConnectionPool;
    private static int testOnlyClientCreatedTimes = 0;
    private static final Map<ConnectionPoolKey, ConnectionWorkerPool> connectionPoolMap = new ConcurrentHashMap<ConnectionPoolKey, ConnectionWorkerPool>();
    private final long creationTimestamp;
    private final RequestProfiler.RequestProfilerHook requestProfilerHook;
    private Lock lock;

    private static Cache<String, String> allocateProjectLocationCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(LOCATION_CACHE_EXPIRE_MILLIS, TimeUnit.MILLISECONDS).build();
    }

    public static long getApiMaxRequestBytes() {
        return ConnectionWorker.getApiMaxRequestBytes();
    }

    private StreamWriter(Builder builder) throws IOException {
        this.streamName = builder.streamName;
        this.writerSchema = builder.writerSchema;
        this.defaultMissingValueInterpretation = builder.defaultMissingValueInterpretation;
        this.missingValueInterpretationMap = builder.missingValueInterpretationMap;
        BigQueryWriteSettings clientSettings = StreamWriter.getBigQueryWriteSettings(builder);
        this.requestProfilerHook = new RequestProfiler.RequestProfilerHook(builder.enableRequestProfiler);
        this.fullTraceId = builder.getFullTraceId();
        if (builder.enableRequestProfiler) {
            this.requestProfilerHook.startPeriodicalReportFlushing();
        }
        if (!builder.enableConnectionPool) {
            this.location = builder.location;
            this.singleConnectionOrConnectionPool = SingleConnectionOrConnectionPool.ofSingleConnection(new ConnectionWorker(builder.streamName, builder.location, builder.writerSchema, builder.maxInflightRequest, builder.maxInflightBytes, builder.maxRetryDuration, builder.limitExceededBehavior, builder.getFullTraceId(), builder.compressorName, clientSettings, builder.retrySettings, builder.enableRequestProfiler, builder.enableOpenTelemetry, false));
        } else {
            if (!StreamWriter.isDefaultStream(this.streamName)) {
                log.warning("Connection pool is only allowed in default stream! However received " + builder.streamName);
                throw new IllegalArgumentException("Trying to enable connection pool in non-default stream.");
            }
            final BigQueryWriteClient client = builder.client != null ? builder.client : new BigQueryWriteClient(clientSettings);
            String location = builder.location;
            if (location == null || location.isEmpty()) {
                final String datasetAndProjectName = StreamWriter.extractDatasetAndProjectName(builder.streamName);
                try {
                    location = projectAndDatasetToLocation.get(datasetAndProjectName, new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            GetWriteStreamRequest writeStreamRequest = GetWriteStreamRequest.newBuilder().setName(StreamWriter.this.getStreamName()).setView(WriteStreamView.BASIC).build();
                            WriteStream writeStream = client.getWriteStream(writeStreamRequest);
                            TableSchema writeStreamTableSchema = writeStream.getTableSchema();
                            String fetchedLocation = writeStream.getLocation();
                            log.info(String.format("Fetched location %s for stream name %s, extracted project and dataset name: %s\"", fetchedLocation, StreamWriter.this.streamName, datasetAndProjectName));
                            return fetchedLocation;
                        }
                    });
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException(e.getCause());
                }
                if (location.isEmpty()) {
                    throw new IllegalStateException(String.format("The location is empty for both user passed in value and looked up value for stream: %s, extracted project and dataset name: %s", this.streamName, datasetAndProjectName));
                }
            }
            this.location = location;
            CredentialsProvider credentialsProvider = client.getSettings().getCredentialsProvider();
            this.singleConnectionOrConnectionPool = SingleConnectionOrConnectionPool.ofConnectionPool(connectionPoolMap.computeIfAbsent(ConnectionPoolKey.create(location, credentialsProvider != null ? credentialsProvider.getCredentials() : null), key -> new ConnectionWorkerPool(builder.maxInflightRequest, builder.maxInflightBytes, builder.maxRetryDuration, builder.limitExceededBehavior, builder.compressorName, client.getSettings(), builder.retrySettings, builder.enableRequestProfiler, builder.enableOpenTelemetry)));
            this.validateFetchedConnectonPool(builder);
            if (builder.client == null) {
                client.shutdown();
                try {
                    client.awaitTermination(150L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                client.close();
            }
        }
        this.creationTimestamp = System.nanoTime();
    }

    @VisibleForTesting
    static String extractDatasetAndProjectName(String streamName) {
        Matcher streamMatcher = streamPatternDatasets.matcher(streamName);
        if (streamMatcher.find()) {
            return streamMatcher.group();
        }
        throw new IllegalStateException(String.format("The passed in stream name does not match standard format %s", streamName));
    }

    @VisibleForTesting
    static boolean isDefaultStream(String streamName) {
        Matcher streamMatcher = streamPatternDefaultStream.matcher(streamName);
        return streamMatcher.find();
    }

    @VisibleForTesting
    static void recreateProjectLocationCache(long durationExpireMillis) {
        LOCATION_CACHE_EXPIRE_MILLIS = durationExpireMillis;
        projectAndDatasetToLocation = StreamWriter.allocateProjectLocationCache();
    }

    String getFullTraceId() {
        return this.fullTraceId;
    }

    AppendRowsRequest.MissingValueInterpretation getDefaultValueInterpretation() {
        return this.defaultMissingValueInterpretation;
    }

    static BigQueryWriteSettings getBigQueryWriteSettings(Builder builder) throws IOException {
        BigQueryWriteSettings.Builder settingsBuilder = null;
        settingsBuilder = builder.client != null ? builder.client.getSettings().toBuilder() : (BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)new BigQueryWriteSettings.Builder().setTransportChannelProvider(BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setKeepAliveTimeDuration(Duration.ofMinutes(1L)).setKeepAliveTimeoutDuration(Duration.ofMinutes(1L)).setKeepAliveWithoutCalls(true).setChannelsPerCpu(2.0).build())).setCredentialsProvider(BigQueryWriteSettings.defaultCredentialsProviderBuilder().build())).setBackgroundExecutorProvider(BigQueryWriteSettings.defaultExecutorProviderBuilder().build())).setEndpoint(BigQueryWriteSettings.getDefaultEndpoint());
        if (builder.channelProvider != null) {
            settingsBuilder.setTransportChannelProvider(builder.channelProvider);
        }
        if (builder.credentialsProvider != null) {
            settingsBuilder.setCredentialsProvider(builder.credentialsProvider);
        }
        if (builder.executorProvider != null) {
            settingsBuilder.setBackgroundExecutorProvider(builder.executorProvider);
        }
        if (builder.endpoint != null) {
            settingsBuilder.setEndpoint(builder.endpoint);
        }
        return settingsBuilder.build();
    }

    private void validateFetchedConnectonPool(Builder builder) {
        FlowController.LimitExceededBehavior storedLimitExceededBehavior = this.singleConnectionOrConnectionPool.connectionWorkerPool().limitExceededBehavior();
        if (!Objects.equals((Object)storedLimitExceededBehavior, (Object)builder.limitExceededBehavior)) {
            throw new IllegalArgumentException(String.format("Limit exceeded behavior setting used for the same connection pool for the same location must be the same, however stored value is %s, and expected value is %s.", new Object[]{storedLimitExceededBehavior, builder.limitExceededBehavior}));
        }
    }

    public ApiFuture<AppendRowsResponse> append(ArrowRecordBatch recordBatch) {
        return this.append(recordBatch, -1L);
    }

    public ApiFuture<AppendRowsResponse> append(ProtoRows rows) {
        return this.append(rows, -1L);
    }

    public ApiFuture<AppendRowsResponse> append(ProtoRows rows, long offset) {
        return this.append(AppendFormats.AppendRowsData.of(rows), offset);
    }

    public ApiFuture<AppendRowsResponse> append(ArrowRecordBatch recordBatch, long offset) {
        return this.append(recordBatch, offset, -1L);
    }

    private ApiFuture<AppendRowsResponse> append(ArrowRecordBatch recordBatch, long offset, long recordBatchRowCount) {
        return this.append(AppendFormats.AppendRowsData.of(recordBatch, recordBatchRowCount), offset);
    }

    public ApiFuture<AppendRowsResponse> append(shaded.bqjdbc.org.apache.arrow.vector.ipc.message.ArrowRecordBatch recordBatch) {
        return this.append(recordBatch, -1L);
    }

    public ApiFuture<AppendRowsResponse> append(shaded.bqjdbc.org.apache.arrow.vector.ipc.message.ArrowRecordBatch recordBatch, long offset) {
        Preconditions.checkNotNull(recordBatch);
        if (this.writerSchema.format() != AppendFormats.DataFormat.ARROW) {
            throw new IllegalStateException("The StreamWriter must be created with Arrow schema to append Arrow data.");
        }
        try {
            ApiFuture<AppendRowsResponse> apiFuture;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                MessageSerializer.serialize(new WriteChannel(Channels.newChannel(out)), recordBatch);
                apiFuture = this.append(ArrowRecordBatch.newBuilder().setSerializedRecordBatch(ByteString.copyFrom(out.toByteArray())).build(), offset, recordBatch.getLength());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription("Failed to serialize arrow record batch.").withCause(e));
                }
            }
            out.close();
            return apiFuture;
        }
        finally {
            recordBatch.close();
        }
    }

    private ApiFuture<AppendRowsResponse> append(AppendFormats.AppendRowsData rows, long offset) {
        String requestUniqueId = this.generateRequestUniqueId();
        this.requestProfilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, requestUniqueId);
        try {
            return this.appendWithUniqueId(rows, offset, requestUniqueId);
        }
        catch (Exception ex) {
            this.requestProfilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, requestUniqueId);
            throw ex;
        }
    }

    ApiFuture<AppendRowsResponse> appendWithUniqueId(ProtoRows rows, long offset, String requestUniqueId) {
        return this.appendWithUniqueId(AppendFormats.AppendRowsData.of(rows), offset, requestUniqueId);
    }

    ApiFuture<AppendRowsResponse> appendWithUniqueId(AppendFormats.AppendRowsData rows, long offset, String requestUniqueId) {
        if (this.userClosed.get()) {
            ConnectionWorker.AppendRequestAndResponse requestWrapper = new ConnectionWorker.AppendRequestAndResponse(AppendRowsRequest.newBuilder().build(), this, null, requestUniqueId, rows.recordBatchRowCount());
            requestWrapper.appendResult.setException(new Exceptions.StreamWriterClosedException(Status.fromCode(Status.Code.FAILED_PRECONDITION).withDescription("User closed StreamWriter"), this.streamName, this.getWriterId()));
            this.requestProfilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, requestUniqueId);
            return requestWrapper.appendResult;
        }
        return this.singleConnectionOrConnectionPool.append(this, rows, offset, requestUniqueId);
    }

    @VisibleForTesting
    Attributes getTelemetryAttributes() {
        return this.singleConnectionOrConnectionPool.getTelemetryAttributes(this);
    }

    public long getInflightWaitSeconds() {
        return this.singleConnectionOrConnectionPool.getInflightWaitSeconds(this);
    }

    public String getWriterId() {
        return this.singleConnectionOrConnectionPool.getWriterId(this.writerId);
    }

    public String getStreamName() {
        return this.streamName;
    }

    AppendFormats.AppendRowsSchema getWriterSchema() {
        return this.writerSchema;
    }

    public ProtoSchema getProtoSchema() {
        if (this.writerSchema.format() == AppendFormats.DataFormat.PROTO) {
            return this.writerSchema.protoSchema();
        }
        throw new IllegalStateException("No Proto schema found.");
    }

    public ArrowSchema getArrowSchema() {
        if (this.writerSchema.format() == AppendFormats.DataFormat.ARROW) {
            return this.writerSchema.arrowSchema();
        }
        throw new IllegalStateException("No Arrow schema found.");
    }

    public String getLocation() {
        return this.location;
    }

    public Map<String, AppendRowsRequest.MissingValueInterpretation> getMissingValueInterpretationMap() {
        return this.missingValueInterpretationMap;
    }

    public boolean isClosed() {
        if (this.singleConnectionOrConnectionPool.getKind() == SingleConnectionOrConnectionPool.Kind.CONNECTION_WORKER) {
            return this.userClosed.get() || this.singleConnectionOrConnectionPool.connectionWorker().isConnectionInUnrecoverableState();
        }
        return this.userClosed.get();
    }

    public boolean isUserClosed() {
        return this.userClosed.get();
    }

    @Override
    public void close() {
        this.userClosed.set(true);
        this.singleConnectionOrConnectionPool.close(this);
    }

    public static Builder newBuilder(String streamName, BigQueryWriteClient client) {
        return new Builder(streamName, client);
    }

    public static Builder newBuilder(String streamName) {
        return new Builder(streamName);
    }

    public synchronized TableSchema getUpdatedSchema() {
        ConnectionWorker.TableSchemaAndTimestamp tableSchemaAndTimestamp = this.singleConnectionOrConnectionPool.getUpdatedSchema(this);
        if (tableSchemaAndTimestamp == null) {
            return null;
        }
        return this.creationTimestamp < tableSchemaAndTimestamp.updateTimeStamp() ? tableSchemaAndTimestamp.updatedSchema() : null;
    }

    public static void setMaxRequestCallbackWaitTime(Duration waitTime) {
        ConnectionWorker.MAXIMUM_REQUEST_CALLBACK_WAIT_TIME = waitTime;
    }

    public static String getDefaultStreamName(TableName tableName) {
        return tableName + defaultStreamMatching;
    }

    long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @VisibleForTesting
    SingleConnectionOrConnectionPool.Kind getConnectionOperationType() {
        return this.singleConnectionOrConnectionPool.getKind();
    }

    @VisibleForTesting
    static int getTestOnlyClientCreatedTimes() {
        return testOnlyClientCreatedTimes;
    }

    @VisibleForTesting
    static void cleanUp() {
        testOnlyClientCreatedTimes = 0;
        connectionPoolMap.clear();
    }

    @VisibleForTesting
    ConnectionWorkerPool getTestOnlyConnectionWorkerPool() {
        ConnectionWorkerPool connectionWorkerPool = null;
        for (Map.Entry<ConnectionPoolKey, ConnectionWorkerPool> entry : connectionPoolMap.entrySet()) {
            connectionWorkerPool = entry.getValue();
        }
        return connectionWorkerPool;
    }

    @VisibleForTesting
    Map<ConnectionPoolKey, ConnectionWorkerPool> getTestOnlyConnectionPoolMap() {
        return connectionPoolMap;
    }

    @VisibleForTesting
    static void clearConnectionPool() {
        connectionPoolMap.clear();
    }

    private String generateRequestUniqueId() {
        return this.getStreamName() + "-" + UUID.randomUUID().toString();
    }

    public static final class Builder {
        private static final long DEFAULT_MAX_INFLIGHT_REQUESTS = 1000L;
        private static final long DEFAULT_MAX_INFLIGHT_BYTES = 0x6400000L;
        private String streamName;
        private BigQueryWriteClient client;
        private AppendFormats.AppendRowsSchema writerSchema = null;
        private long maxInflightRequest = 1000L;
        private long maxInflightBytes = 0x6400000L;
        private String endpoint = null;
        private TransportChannelProvider channelProvider = null;
        private CredentialsProvider credentialsProvider = null;
        private ExecutorProvider executorProvider = null;
        private FlowController.LimitExceededBehavior limitExceededBehavior = FlowController.LimitExceededBehavior.Block;
        private String traceId = null;
        private String clientId = "java-streamwriter";
        private TableSchema updatedTableSchema = null;
        private String location = null;
        private boolean enableConnectionPool = false;
        private Duration maxRetryDuration = Duration.ofMinutes(5L);
        private String compressorName = null;
        private AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation = AppendRowsRequest.MissingValueInterpretation.MISSING_VALUE_INTERPRETATION_UNSPECIFIED;
        private Map<String, AppendRowsRequest.MissingValueInterpretation> missingValueInterpretationMap = new HashMap<String, AppendRowsRequest.MissingValueInterpretation>();
        private boolean enableRequestProfiler = false;
        private boolean enableOpenTelemetry = false;
        private RetrySettings retrySettings = null;

        private Builder(String streamName) {
            this.streamName = Preconditions.checkNotNull(streamName);
            this.client = null;
        }

        private Builder(String streamName, BigQueryWriteClient client) {
            this.streamName = Preconditions.checkNotNull(streamName);
            this.client = Preconditions.checkNotNull(client);
        }

        @CanIgnoreReturnValue
        public Builder setWriterSchema(ProtoSchema protoSchema) {
            this.writerSchema = AppendFormats.AppendRowsSchema.of(protoSchema);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWriterSchema(ArrowSchema arrowSchema) {
            this.writerSchema = AppendFormats.AppendRowsSchema.of(arrowSchema);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWriterSchema(Schema arrowSchema) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                MessageSerializer.serialize(new WriteChannel(Channels.newChannel(out)), arrowSchema);
                this.writerSchema = AppendFormats.AppendRowsSchema.of(ArrowSchema.newBuilder().setSerializedSchema(ByteString.copyFrom(out.toByteArray())).build());
            }
            catch (IOException e) {
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription("Failed to serialize arrow schema."));
            }
            return this;
        }

        public Builder setMaxInflightRequests(long value) {
            this.maxInflightRequest = value;
            return this;
        }

        public Builder setMaxInflightBytes(long value) {
            this.maxInflightBytes = value;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = Preconditions.checkNotNull(endpoint, "Endpoint is null.");
            return this;
        }

        public Builder setEnableConnectionPool(boolean enableConnectionPool) {
            this.enableConnectionPool = enableConnectionPool;
            return this;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = Preconditions.checkNotNull(channelProvider, "ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = Preconditions.checkNotNull(credentialsProvider, "CredentialsProvider is null.");
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = Preconditions.checkNotNull(executorProvider, "ExecutorProvider is null.");
            return this;
        }

        public Builder setTraceId(String traceId) {
            int colonIndex = traceId.indexOf(58);
            if (colonIndex == -1 || colonIndex == 0 || colonIndex == traceId.length() - 1) {
                throw new IllegalArgumentException("TraceId must follow the format of A:B. Actual:" + traceId);
            }
            this.traceId = traceId;
            return this;
        }

        Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLimitExceededBehavior(FlowController.LimitExceededBehavior limitExceededBehavior) throws StatusRuntimeException {
            if (limitExceededBehavior == FlowController.LimitExceededBehavior.Ignore) {
                throw new StatusRuntimeException(Status.fromCode(Status.Code.INVALID_ARGUMENT).withDescription("LimitExceededBehavior.Ignore is not supported on StreamWriter."));
            }
            this.limitExceededBehavior = limitExceededBehavior;
            return this;
        }

        public Builder setMaxRetryDuration(Duration maxRetryDuration) {
            this.maxRetryDuration = maxRetryDuration;
            return this;
        }

        public Builder setCompressorName(String compressorName) {
            Preconditions.checkNotNull(compressorName);
            Preconditions.checkArgument(compressorName.equals("gzip"), "Compression of type \"%s\" isn't supported, only \"gzip\" compression is supported.", (Object)compressorName);
            this.compressorName = compressorName;
            return this;
        }

        public Builder setDefaultMissingValueInterpretation(AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation) {
            this.defaultMissingValueInterpretation = defaultMissingValueInterpretation;
            return this;
        }

        public Builder setMissingValueInterpretationMap(Map<String, AppendRowsRequest.MissingValueInterpretation> missingValueInterpretationMap) {
            this.missingValueInterpretationMap = missingValueInterpretationMap;
            return this;
        }

        public Builder setEnableLatencyProfiler(boolean enableLatencyProfiler) {
            this.enableRequestProfiler = enableLatencyProfiler;
            return this;
        }

        public Builder setEnableOpenTelemetry(boolean enableOpenTelemetry) {
            this.enableOpenTelemetry = enableOpenTelemetry;
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            this.retrySettings = retrySettings;
            return this;
        }

        public StreamWriter build() throws IOException {
            return new StreamWriter(this);
        }

        String getFullTraceId() {
            String clientWithVersion;
            String string = clientWithVersion = GaxProperties.getLibraryVersion(StreamWriter.class).isEmpty() ? this.clientId : this.clientId + ":" + GaxProperties.getLibraryVersion(StreamWriter.class);
            if (this.traceId == null || this.traceId.isEmpty()) {
                return clientWithVersion;
            }
            return clientWithVersion + " " + this.traceId;
        }
    }

    @AutoOneOf(value=Kind.class)
    static abstract class SingleConnectionOrConnectionPool {
        SingleConnectionOrConnectionPool() {
        }

        abstract Kind getKind();

        abstract ConnectionWorker connectionWorker();

        abstract ConnectionWorkerPool connectionWorkerPool();

        ApiFuture<AppendRowsResponse> append(StreamWriter streamWriter, AppendFormats.AppendRowsData rows, long offset, String requestUniqueId) {
            if (this.getKind() == Kind.CONNECTION_WORKER) {
                return this.connectionWorker().append(streamWriter, rows, offset, requestUniqueId);
            }
            return this.connectionWorkerPool().append(streamWriter, rows, offset, requestUniqueId);
        }

        @VisibleForTesting
        Attributes getTelemetryAttributes(StreamWriter streamWriter) {
            if (this.getKind() == Kind.CONNECTION_WORKER) {
                return this.connectionWorker().getTelemetryAttributes();
            }
            return this.connectionWorkerPool().getTelemetryAttributes(streamWriter);
        }

        void close(StreamWriter streamWriter) {
            if (this.getKind() == Kind.CONNECTION_WORKER) {
                this.connectionWorker().close();
            } else {
                this.connectionWorkerPool().close(streamWriter);
            }
        }

        long getInflightWaitSeconds(StreamWriter streamWriter) {
            if (this.getKind() == Kind.CONNECTION_WORKER_POOL) {
                return this.connectionWorkerPool().getInflightWaitSeconds(streamWriter);
            }
            return this.connectionWorker().getInflightWaitSeconds();
        }

        ConnectionWorker.TableSchemaAndTimestamp getUpdatedSchema(StreamWriter streamWriter) {
            if (this.getKind() == Kind.CONNECTION_WORKER_POOL) {
                return this.connectionWorkerPool().getUpdatedSchema(streamWriter);
            }
            return this.connectionWorker().getUpdatedSchema();
        }

        String getWriterId(String streamWriterId) {
            if (this.getKind() == Kind.CONNECTION_WORKER_POOL) {
                return streamWriterId;
            }
            return this.connectionWorker().getWriterId();
        }

        static SingleConnectionOrConnectionPool ofSingleConnection(ConnectionWorker connection) {
            return AutoOneOf_StreamWriter_SingleConnectionOrConnectionPool.connectionWorker(connection);
        }

        static SingleConnectionOrConnectionPool ofConnectionPool(ConnectionWorkerPool connectionPool) {
            return AutoOneOf_StreamWriter_SingleConnectionOrConnectionPool.connectionWorkerPool(connectionPool);
        }

        public static enum Kind {
            CONNECTION_WORKER,
            CONNECTION_WORKER_POOL;

        }
    }

    @AutoValue
    static abstract class ConnectionPoolKey {
        ConnectionPoolKey() {
        }

        abstract String location();

        abstract int credentialsHashcode();

        public static ConnectionPoolKey create(String location, @Nullable Credentials credentials) {
            return new AutoValue_StreamWriter_ConnectionPoolKey(location, credentials != null ? credentials.hashCode() : 0);
        }
    }
}

