/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.stub;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import shaded.bqjdbc.com.google.api.core.ApiFunction;
import shaded.bqjdbc.com.google.api.core.BetaApi;
import shaded.bqjdbc.com.google.api.core.ObsoleteApi;
import shaded.bqjdbc.com.google.api.gax.core.GaxProperties;
import shaded.bqjdbc.com.google.api.gax.core.GoogleCredentialsProvider;
import shaded.bqjdbc.com.google.api.gax.core.InstantiatingExecutorProvider;
import shaded.bqjdbc.com.google.api.gax.grpc.GaxGrpcProperties;
import shaded.bqjdbc.com.google.api.gax.grpc.GrpcTransportChannel;
import shaded.bqjdbc.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import shaded.bqjdbc.com.google.api.gax.retrying.RetrySettings;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiClientHeaderProvider;
import shaded.bqjdbc.com.google.api.gax.rpc.ClientContext;
import shaded.bqjdbc.com.google.api.gax.rpc.StatusCode;
import shaded.bqjdbc.com.google.api.gax.rpc.StreamingCallSettings;
import shaded.bqjdbc.com.google.api.gax.rpc.StubSettings;
import shaded.bqjdbc.com.google.api.gax.rpc.TransportChannelProvider;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallSettings;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.BatchDeleteMetastorePartitionsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.stub.GrpcMetastorePartitionServiceStub;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1alpha.stub.MetastorePartitionServiceStub;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.com.google.common.collect.ImmutableMap;
import shaded.bqjdbc.com.google.common.collect.ImmutableSet;
import shaded.bqjdbc.com.google.common.collect.Lists;
import shaded.bqjdbc.com.google.protobuf.Empty;

@BetaApi
public class MetastorePartitionServiceStubSettings
extends StubSettings<MetastorePartitionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/bigquery")).add("https://www.googleapis.com/auth/cloud-platform")).build();
    private final UnaryCallSettings<BatchCreateMetastorePartitionsRequest, BatchCreateMetastorePartitionsResponse> batchCreateMetastorePartitionsSettings;
    private final UnaryCallSettings<BatchDeleteMetastorePartitionsRequest, Empty> batchDeleteMetastorePartitionsSettings;
    private final UnaryCallSettings<BatchUpdateMetastorePartitionsRequest, BatchUpdateMetastorePartitionsResponse> batchUpdateMetastorePartitionsSettings;
    private final UnaryCallSettings<ListMetastorePartitionsRequest, ListMetastorePartitionsResponse> listMetastorePartitionsSettings;
    private final StreamingCallSettings<StreamMetastorePartitionsRequest, StreamMetastorePartitionsResponse> streamMetastorePartitionsSettings;

    public UnaryCallSettings<BatchCreateMetastorePartitionsRequest, BatchCreateMetastorePartitionsResponse> batchCreateMetastorePartitionsSettings() {
        return this.batchCreateMetastorePartitionsSettings;
    }

    public UnaryCallSettings<BatchDeleteMetastorePartitionsRequest, Empty> batchDeleteMetastorePartitionsSettings() {
        return this.batchDeleteMetastorePartitionsSettings;
    }

    public UnaryCallSettings<BatchUpdateMetastorePartitionsRequest, BatchUpdateMetastorePartitionsResponse> batchUpdateMetastorePartitionsSettings() {
        return this.batchUpdateMetastorePartitionsSettings;
    }

    public UnaryCallSettings<ListMetastorePartitionsRequest, ListMetastorePartitionsResponse> listMetastorePartitionsSettings() {
        return this.listMetastorePartitionsSettings;
    }

    public StreamingCallSettings<StreamMetastorePartitionsRequest, StreamMetastorePartitionsResponse> streamMetastorePartitionsSettings() {
        return this.streamMetastorePartitionsSettings;
    }

    public MetastorePartitionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMetastorePartitionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    @Override
    public String getServiceName() {
        return "bigquerystorage";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "bigquerystorage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigquerystorage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MetastorePartitionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MetastorePartitionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MetastorePartitionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.batchCreateMetastorePartitionsSettings = settingsBuilder.batchCreateMetastorePartitionsSettings().build();
        this.batchDeleteMetastorePartitionsSettings = settingsBuilder.batchDeleteMetastorePartitionsSettings().build();
        this.batchUpdateMetastorePartitionsSettings = settingsBuilder.batchUpdateMetastorePartitionsSettings().build();
        this.listMetastorePartitionsSettings = settingsBuilder.listMetastorePartitionsSettings().build();
        this.streamMetastorePartitionsSettings = settingsBuilder.streamMetastorePartitionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MetastorePartitionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<BatchCreateMetastorePartitionsRequest, BatchCreateMetastorePartitionsResponse> batchCreateMetastorePartitionsSettings;
        private final UnaryCallSettings.Builder<BatchDeleteMetastorePartitionsRequest, Empty> batchDeleteMetastorePartitionsSettings;
        private final UnaryCallSettings.Builder<BatchUpdateMetastorePartitionsRequest, BatchUpdateMetastorePartitionsResponse> batchUpdateMetastorePartitionsSettings;
        private final UnaryCallSettings.Builder<ListMetastorePartitionsRequest, ListMetastorePartitionsResponse> listMetastorePartitionsSettings;
        private final StreamingCallSettings.Builder<StreamMetastorePartitionsRequest, StreamMetastorePartitionsResponse> streamMetastorePartitionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.batchCreateMetastorePartitionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteMetastorePartitionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateMetastorePartitionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMetastorePartitionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.streamMetastorePartitionsSettings = StreamingCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.batchCreateMetastorePartitionsSettings, this.batchDeleteMetastorePartitionsSettings, this.batchUpdateMetastorePartitionsSettings, this.listMetastorePartitionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MetastorePartitionServiceStubSettings settings) {
            super(settings);
            this.batchCreateMetastorePartitionsSettings = settings.batchCreateMetastorePartitionsSettings.toBuilder();
            this.batchDeleteMetastorePartitionsSettings = settings.batchDeleteMetastorePartitionsSettings.toBuilder();
            this.batchUpdateMetastorePartitionsSettings = settings.batchUpdateMetastorePartitionsSettings.toBuilder();
            this.listMetastorePartitionsSettings = settings.listMetastorePartitionsSettings.toBuilder();
            this.streamMetastorePartitionsSettings = settings.streamMetastorePartitionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.batchCreateMetastorePartitionsSettings, this.batchDeleteMetastorePartitionsSettings, this.batchUpdateMetastorePartitionsSettings, this.listMetastorePartitionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MetastorePartitionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(MetastorePartitionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(MetastorePartitionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MetastorePartitionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.batchCreateMetastorePartitionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.batchDeleteMetastorePartitionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.batchUpdateMetastorePartitionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.listMetastorePartitionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<BatchCreateMetastorePartitionsRequest, BatchCreateMetastorePartitionsResponse> batchCreateMetastorePartitionsSettings() {
            return this.batchCreateMetastorePartitionsSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteMetastorePartitionsRequest, Empty> batchDeleteMetastorePartitionsSettings() {
            return this.batchDeleteMetastorePartitionsSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateMetastorePartitionsRequest, BatchUpdateMetastorePartitionsResponse> batchUpdateMetastorePartitionsSettings() {
            return this.batchUpdateMetastorePartitionsSettings;
        }

        public UnaryCallSettings.Builder<ListMetastorePartitionsRequest, ListMetastorePartitionsResponse> listMetastorePartitionsSettings() {
            return this.listMetastorePartitionsSettings;
        }

        public StreamingCallSettings.Builder<StreamMetastorePartitionsRequest, StreamMetastorePartitionsResponse> streamMetastorePartitionsSettings() {
            return this.streamMetastorePartitionsSettings;
        }

        public MetastorePartitionServiceStubSettings build() throws IOException {
            return new MetastorePartitionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("retry_policy_0_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE)));
            definitions.put("no_retry_1_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(240000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(240000L)).setTotalTimeoutDuration(Duration.ofMillis(240000L)).build();
            definitions.put("retry_policy_0_params", settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(240000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(240000L)).setTotalTimeoutDuration(Duration.ofMillis(240000L)).build();
            definitions.put("no_retry_1_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

