/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta1.stub.readrows;

import javax.annotation.Nonnull;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.gax.retrying.StreamResumptionStrategy;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta1.Storage;

@InternalApi
public class ReadRowsResumptionStrategy
implements StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse> {
    private long rowsProcessed = 0L;

    @Override
    @Nonnull
    public StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse> createNew() {
        return new ReadRowsResumptionStrategy();
    }

    @Override
    @Nonnull
    public Storage.ReadRowsResponse processResponse(Storage.ReadRowsResponse response) {
        this.rowsProcessed += response.getRowCount();
        return response;
    }

    @Override
    public Storage.ReadRowsRequest getResumeRequest(Storage.ReadRowsRequest originalRequest) {
        Storage.ReadRowsRequest.Builder resumeRequestBuilder = originalRequest.toBuilder();
        resumeRequestBuilder.getReadPositionBuilder().setOffset(originalRequest.getReadPosition().getOffset() + this.rowsProcessed);
        return resumeRequestBuilder.build();
    }

    @Override
    public boolean canResume() {
        return true;
    }
}

