/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import shaded.bqjdbc.com.google.api.core.BetaApi;
import shaded.bqjdbc.com.google.api.gax.core.BackgroundResource;
import shaded.bqjdbc.com.google.api.gax.rpc.ServerStreamingCallable;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallable;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2.BigQueryReadSettings;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2.CreateReadSessionRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2.ReadSession;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1beta2.stub.EnhancedBigQueryReadStub;

@BetaApi
public class BigQueryReadClient
implements BackgroundResource {
    private final BigQueryReadSettings settings;
    private final EnhancedBigQueryReadStub stub;

    public static final BigQueryReadClient create() throws IOException {
        return BigQueryReadClient.create(BigQueryReadSettings.newBuilder().build());
    }

    public static final BigQueryReadClient create(BigQueryReadSettings settings) throws IOException {
        return new BigQueryReadClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BigQueryReadClient create(EnhancedBigQueryReadStub stub) {
        return new BigQueryReadClient(stub);
    }

    protected BigQueryReadClient(BigQueryReadSettings settings) throws IOException {
        this.settings = settings;
        this.stub = EnhancedBigQueryReadStub.create(settings.getTypedStubSettings(), settings.getReadRowsRetryAttemptListener());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BigQueryReadClient(EnhancedBigQueryReadStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BigQueryReadSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EnhancedBigQueryReadStub getStub() {
        return this.stub;
    }

    public final ReadSession createReadSession(String parent, ReadSession readSession, int maxStreamCount) {
        CreateReadSessionRequest request = CreateReadSessionRequest.newBuilder().setParent(parent).setReadSession(readSession).setMaxStreamCount(maxStreamCount).build();
        return this.createReadSession(request);
    }

    public final ReadSession createReadSession(CreateReadSessionRequest request) {
        return this.createReadSessionCallable().call(request);
    }

    public final UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public final SplitReadStreamResponse splitReadStream(SplitReadStreamRequest request) {
        return this.splitReadStreamCallable().call(request);
    }

    public final UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

