/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.http;

import java.io.IOException;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.api.client.http.HttpExecuteInterceptor;
import shaded.bqjdbc.com.google.api.client.http.HttpHeaders;
import shaded.bqjdbc.com.google.api.client.http.HttpRequest;
import shaded.bqjdbc.com.google.api.client.http.HttpRequestInitializer;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.io.opencensus.contrib.http.util.HttpPropagationUtil;
import shaded.bqjdbc.io.opencensus.trace.SpanContext;
import shaded.bqjdbc.io.opencensus.trace.Tracer;
import shaded.bqjdbc.io.opencensus.trace.propagation.TextFormat;

public final class CensusHttpModule {
    private final Tracer tracer;
    @Nullable
    private final TextFormat propagationTextFormat;
    @Nullable
    private final TextFormat.Setter<HttpHeaders> propagationTextFormatSetter;
    private final boolean isRecordEvents;

    public CensusHttpModule(Tracer tracer, boolean isRecordEvents) {
        Preconditions.checkNotNull(tracer, "tracer");
        this.tracer = tracer;
        this.isRecordEvents = isRecordEvents;
        this.propagationTextFormat = HttpPropagationUtil.getCloudTraceFormat();
        this.propagationTextFormatSetter = DefaultPropagationTextFormatSetter.INSTANCE;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public boolean isRecordEvents() {
        return this.isRecordEvents;
    }

    public HttpRequestInitializer getHttpRequestInitializer(HttpRequestInitializer initializer) {
        return new CensusHttpRequestInitializer(initializer);
    }

    @VisibleForTesting
    static final class DefaultPropagationTextFormatSetter
    extends TextFormat.Setter<HttpHeaders> {
        static final TextFormat.Setter<HttpHeaders> INSTANCE = new DefaultPropagationTextFormatSetter();

        DefaultPropagationTextFormatSetter() {
        }

        @Override
        public void put(HttpHeaders carrier, String key, String value) {
            carrier.set(key, value);
        }
    }

    @VisibleForTesting
    final class CensusHttpRequestInitializer
    implements HttpRequestInitializer {
        @Nullable
        HttpRequestInitializer initializer;

        CensusHttpRequestInitializer(HttpRequestInitializer initializer) {
            this.initializer = initializer;
        }

        @Override
        public void initialize(HttpRequest request) throws IOException {
            Preconditions.checkNotNull(request);
            if (this.initializer != null) {
                this.initializer.initialize(request);
            }
            request.setInterceptor(new CensusHttpExecuteInterceptor(request.getInterceptor()));
        }
    }

    @VisibleForTesting
    final class CensusHttpExecuteInterceptor
    implements HttpExecuteInterceptor {
        @Nullable
        HttpExecuteInterceptor interceptor;

        CensusHttpExecuteInterceptor(HttpExecuteInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        @Override
        public void intercept(HttpRequest request) throws IOException {
            SpanContext spanContext;
            Preconditions.checkNotNull(request);
            if (this.interceptor != null) {
                this.interceptor.intercept(request);
            }
            if (CensusHttpModule.this.propagationTextFormat != null && CensusHttpModule.this.propagationTextFormatSetter != null && !SpanContext.INVALID.equals(spanContext = CensusHttpModule.this.tracer.getCurrentSpan().getContext())) {
                CensusHttpModule.this.propagationTextFormat.inject(spanContext, request.getHeaders(), CensusHttpModule.this.propagationTextFormatSetter);
            }
        }
    }
}

