/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.cloud.testing;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LogRecorder {
    private final Pattern logLinePattern = Pattern.compile("([A-Z]+):.*");
    private final Logger logger;
    private StringBuilder logs;

    public LogRecorder(Logger logger) {
        this.logger = logger;
        this.logs = new StringBuilder();
    }

    public void record(String logLine) {
        if (this.hasLevel(logLine)) {
            String stripLevel = logLine.split(":")[1].trim();
            this.logs.append(stripLevel);
        } else {
            this.logs.append(logLine);
        }
        this.logs.append(System.getProperty("line.separator"));
    }

    public void flush() {
        if (this.logs.length() > 0) {
            this.logger.log(Level.INFO, this.logs.toString());
            this.logs = new StringBuilder();
        }
    }

    private boolean hasLevel(String line) {
        return this.getLevel(line) != null;
    }

    private Level getLevel(String line) {
        try {
            Matcher matcher = this.logLinePattern.matcher(line);
            if (matcher.matches()) {
                return Level.parse(matcher.group(1));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

