/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.flatbuffers;

import java.nio.ByteBuffer;
import shaded.bqjdbc.com.google.flatbuffers.Utf8Safe;

public abstract class Utf8 {
    private static Utf8 DEFAULT;

    public abstract int encodedLength(CharSequence var1);

    public abstract void encodeUtf8(CharSequence var1, ByteBuffer var2);

    public abstract String decodeUtf8(ByteBuffer var1, int var2, int var3);

    public static Utf8 getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Utf8Safe();
        }
        return DEFAULT;
    }

    public static void setDefault(Utf8 instance) {
        DEFAULT = instance;
    }

    public static int encodeUtf8CodePoint(CharSequence in, int start, byte[] out) {
        char low;
        assert (out.length >= 4);
        int inLength = in.length();
        if (start >= inLength) {
            return 0;
        }
        char c = in.charAt(start);
        if (c < '\u0080') {
            out[0] = (byte)c;
            return 1;
        }
        if (c < '\u0800') {
            out[0] = (byte)(0xC0 | c >>> 6);
            out[1] = (byte)(0x80 | 0x3F & c);
            return 2;
        }
        if (c < '\ud800' || '\udfff' < c) {
            out[0] = (byte)(0xE0 | c >>> 12);
            out[1] = (byte)(0x80 | 0x3F & c >>> 6);
            out[2] = (byte)(0x80 | 0x3F & c);
            return 3;
        }
        if (start + 1 == inLength || !Character.isSurrogatePair(c, low = in.charAt(start + 1))) {
            throw new UnpairedSurrogateException(start, inLength);
        }
        int codePoint = Character.toCodePoint(c, low);
        out[0] = (byte)(0xF0 | codePoint >>> 18);
        out[1] = (byte)(0x80 | 0x3F & codePoint >>> 12);
        out[2] = (byte)(0x80 | 0x3F & codePoint >>> 6);
        out[3] = (byte)(0x80 | 0x3F & codePoint);
        return 4;
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int index, int length) {
            super("Unpaired surrogate at index " + index + " of " + length);
        }
    }

    static class DecodeUtil {
        DecodeUtil() {
        }

        static boolean isOneByte(byte b) {
            return b >= 0;
        }

        static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        static void handleOneByte(byte byte1, char[] resultArr, int resultPos) {
            resultArr[resultPos] = (char)byte1;
        }

        static void handleTwoBytes(byte byte1, byte byte2, char[] resultArr, int resultPos) throws IllegalArgumentException {
            if (byte1 < -62) {
                throw new IllegalArgumentException("Invalid UTF-8: Illegal leading byte in 2 bytes utf");
            }
            if (DecodeUtil.isNotTrailingByte(byte2)) {
                throw new IllegalArgumentException("Invalid UTF-8: Illegal trailing byte in 2 bytes utf");
            }
            resultArr[resultPos] = (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2));
        }

        static void handleThreeBytes(byte byte1, byte byte2, byte byte3, char[] resultArr, int resultPos) throws IllegalArgumentException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            resultArr[resultPos] = (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3));
        }

        static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, char[] resultArr, int resultPos) throws IllegalArgumentException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            resultArr[resultPos] = DecodeUtil.highSurrogate(codepoint);
            resultArr[resultPos + 1] = DecodeUtil.lowSurrogate(codepoint);
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }
}

