/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.io.grpc.BinaryLog;
import shaded.bqjdbc.io.grpc.BindableService;
import shaded.bqjdbc.io.grpc.CompressorRegistry;
import shaded.bqjdbc.io.grpc.DecompressorRegistry;
import shaded.bqjdbc.io.grpc.ExperimentalApi;
import shaded.bqjdbc.io.grpc.HandlerRegistry;
import shaded.bqjdbc.io.grpc.Server;
import shaded.bqjdbc.io.grpc.ServerCallExecutorSupplier;
import shaded.bqjdbc.io.grpc.ServerInterceptor;
import shaded.bqjdbc.io.grpc.ServerProvider;
import shaded.bqjdbc.io.grpc.ServerServiceDefinition;
import shaded.bqjdbc.io.grpc.ServerStreamTracer;
import shaded.bqjdbc.io.grpc.ServerTransportFilter;

public abstract class ServerBuilder<T extends ServerBuilder<T>> {
    public static ServerBuilder<?> forPort(int port) {
        return ServerProvider.provider().builderForPort(port);
    }

    public abstract T directExecutor();

    public abstract T executor(@Nullable Executor var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8274")
    public T callExecutor(ServerCallExecutorSupplier executorSupplier) {
        return this.thisT();
    }

    public abstract T addService(ServerServiceDefinition var1);

    public abstract T addService(BindableService var1);

    public final T addServices(List<ServerServiceDefinition> services) {
        Preconditions.checkNotNull(services, "services");
        for (ServerServiceDefinition service : services) {
            this.addService(service);
        }
        return this.thisT();
    }

    public T intercept(ServerInterceptor interceptor) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2132")
    public T addTransportFilter(ServerTransportFilter filter) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        throw new UnsupportedOperationException();
    }

    public abstract T fallbackHandlerRegistry(@Nullable HandlerRegistry var1);

    public abstract T useTransportSecurity(File var1, File var2);

    public T useTransportSecurity(InputStream certChain, InputStream privateKey) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public abstract T decompressorRegistry(@Nullable DecompressorRegistry var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public abstract T compressorRegistry(@Nullable CompressorRegistry var1);

    public T handshakeTimeout(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9009")
    public T keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9009")
    public T keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9009")
    public T maxConnectionIdle(long maxConnectionIdle, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9009")
    public T maxConnectionAge(long maxConnectionAge, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9009")
    public T maxConnectionAgeGrace(long maxConnectionAgeGrace, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9009")
    public T permitKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9009")
    public T permitKeepAliveWithoutCalls(boolean permit) {
        throw new UnsupportedOperationException();
    }

    public T maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument(bytes >= 0, "bytes must be >= 0");
        return this.thisT();
    }

    public T maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        return this.thisT();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4017")
    public T setBinaryLog(BinaryLog binaryLog) {
        throw new UnsupportedOperationException();
    }

    public abstract Server build();

    private T thisT() {
        ServerBuilder thisT = this;
        return (T)thisT;
    }
}

