/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.alts;

import javax.net.ssl.SSLException;
import shaded.bqjdbc.com.google.auth.oauth2.ComputeEngineCredentials;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.io.grpc.CallCredentials;
import shaded.bqjdbc.io.grpc.ChannelCredentials;
import shaded.bqjdbc.io.grpc.CompositeChannelCredentials;
import shaded.bqjdbc.io.grpc.Status;
import shaded.bqjdbc.io.grpc.alts.FailingCallCredentials;
import shaded.bqjdbc.io.grpc.alts.HandshakerServiceChannel;
import shaded.bqjdbc.io.grpc.alts.InternalCheckGcpEnvironment;
import shaded.bqjdbc.io.grpc.alts.internal.AltsProtocolNegotiator;
import shaded.bqjdbc.io.grpc.auth.MoreCallCredentials;
import shaded.bqjdbc.io.grpc.internal.SharedResourcePool;
import shaded.bqjdbc.io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import shaded.bqjdbc.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import shaded.bqjdbc.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;

public final class ComputeEngineChannelCredentials {
    private ComputeEngineChannelCredentials() {
    }

    public static ChannelCredentials create() {
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(ComputeEngineChannelCredentials.createClientFactory());
        CallCredentials callCredentials = InternalCheckGcpEnvironment.isOnGcp() ? MoreCallCredentials.from(ComputeEngineCredentials.create()) : new FailingCallCredentials(Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform"));
        return CompositeChannelCredentials.create(nettyCredentials, callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
    }
}

