/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.alts;

import java.io.IOException;
import javax.net.ssl.SSLException;
import shaded.bqjdbc.com.google.auth.oauth2.GoogleCredentials;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.io.grpc.CallCredentials;
import shaded.bqjdbc.io.grpc.ChannelCredentials;
import shaded.bqjdbc.io.grpc.CompositeChannelCredentials;
import shaded.bqjdbc.io.grpc.Status;
import shaded.bqjdbc.io.grpc.alts.DualCallCredentials;
import shaded.bqjdbc.io.grpc.alts.FailingCallCredentials;
import shaded.bqjdbc.io.grpc.alts.HandshakerServiceChannel;
import shaded.bqjdbc.io.grpc.alts.internal.AltsProtocolNegotiator;
import shaded.bqjdbc.io.grpc.auth.MoreCallCredentials;
import shaded.bqjdbc.io.grpc.internal.SharedResourcePool;
import shaded.bqjdbc.io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import shaded.bqjdbc.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import shaded.bqjdbc.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;

public final class GoogleDefaultChannelCredentials {
    private GoogleDefaultChannelCredentials() {
    }

    public static ChannelCredentials create() {
        return GoogleDefaultChannelCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private CallCredentials callCredentials;
        private CallCredentials altsCallCredentials;

        private Builder() {
        }

        public Builder callCredentials(CallCredentials callCreds) {
            this.callCredentials = callCreds;
            return this;
        }

        public Builder altsCallCredentials(CallCredentials callCreds) {
            this.altsCallCredentials = callCreds;
            return this;
        }

        public ChannelCredentials build() {
            ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(Builder.createClientFactory());
            CallCredentials tlsCallCreds = this.callCredentials;
            if (tlsCallCreds == null) {
                try {
                    tlsCallCreds = MoreCallCredentials.from(GoogleCredentials.getApplicationDefault());
                }
                catch (IOException e) {
                    tlsCallCreds = new FailingCallCredentials(Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause(e));
                }
            }
            CallCredentials callCreds = this.altsCallCredentials == null ? tlsCallCreds : new DualCallCredentials(tlsCallCreds, this.altsCallCredentials);
            return CompositeChannelCredentials.create(nettyCredentials, callCreds);
        }

        private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
            SslContext sslContext;
            try {
                sslContext = GrpcSslContexts.forClient().build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
            return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
        }
    }
}

