/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.alts;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import shaded.bqjdbc.io.grpc.CallOptions;
import shaded.bqjdbc.io.grpc.Channel;
import shaded.bqjdbc.io.grpc.ClientCall;
import shaded.bqjdbc.io.grpc.ManagedChannel;
import shaded.bqjdbc.io.grpc.MethodDescriptor;
import shaded.bqjdbc.io.grpc.internal.GrpcUtil;
import shaded.bqjdbc.io.grpc.internal.SharedResourceHolder;
import shaded.bqjdbc.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;

final class HandshakerServiceChannel {
    static final SharedResourceHolder.Resource<Channel> SHARED_HANDSHAKER_CHANNEL = new ChannelResource("metadata.google.internal.:8080");
    private static final boolean EXPERIMENTAL_ALTS_HANDSHAKER_KEEPALIVE_PARAMS = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_ALTS_HANDSHAKER_KEEPALIVE_PARAMS", false);

    HandshakerServiceChannel() {
    }

    static SharedResourceHolder.Resource<Channel> getHandshakerChannelForTesting(String handshakerAddress) {
        return new ChannelResource(handshakerAddress);
    }

    private static class EventLoopHoldingChannel
    extends ForwardingChannel {
        private final ManagedChannel delegate;
        private final EventLoopGroup eventLoopGroup;

        public EventLoopHoldingChannel(ManagedChannel delegate, EventLoopGroup eventLoopGroup) {
            this.delegate = delegate;
            this.eventLoopGroup = eventLoopGroup;
        }

        @Override
        protected Channel delegate() {
            return this.delegate;
        }

        public void close() {
            this.delegate.shutdownNow();
            boolean terminated = false;
            try {
                terminated = this.delegate.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long quietPeriodSeconds = terminated ? 0L : 1L;
            this.eventLoopGroup.shutdownGracefully(quietPeriodSeconds, 10L, TimeUnit.SECONDS);
        }
    }

    private static abstract class ForwardingChannel
    extends Channel {
        private ForwardingChannel() {
        }

        protected abstract Channel delegate();

        @Override
        public String authority() {
            return this.delegate().authority();
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions options) {
            return this.delegate().newCall(methodDescriptor, options);
        }
    }

    private static class ChannelResource
    implements SharedResourceHolder.Resource<Channel> {
        private final String target;

        public ChannelResource(String target) {
            this.target = target;
        }

        @Override
        public Channel create() {
            NioEventLoopGroup eventGroup = new NioEventLoopGroup(1, new DefaultThreadFactory("handshaker pool", true));
            NettyChannelBuilder channelBuilder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget(this.target).channelType(NioSocketChannel.class, InetSocketAddress.class).directExecutor()).eventLoopGroup(eventGroup).usePlaintext();
            if (EXPERIMENTAL_ALTS_HANDSHAKER_KEEPALIVE_PARAMS) {
                channelBuilder.keepAliveTime(10L, TimeUnit.MINUTES).keepAliveTimeout(10L, TimeUnit.SECONDS);
            }
            ManagedChannel channel = channelBuilder.build();
            return new EventLoopHoldingChannel(channel, eventGroup);
        }

        @Override
        public void close(Channel instanceChannel) {
            ((EventLoopHoldingChannel)instanceChannel).close();
        }

        public String toString() {
            return "grpc-alts-handshaker-service-channel";
        }
    }
}

