/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.alts.internal;

import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.io.grpc.alts.internal.AltsHandshakerOptions;
import shaded.bqjdbc.io.grpc.alts.internal.RpcProtocolVersions;

public final class AltsClientOptions
extends AltsHandshakerOptions {
    @Nullable
    private final String targetName;
    private final ImmutableList<String> targetServiceAccounts;

    private AltsClientOptions(Builder builder) {
        super(builder.rpcProtocolVersions);
        this.targetName = builder.targetName;
        this.targetServiceAccounts = builder.targetServiceAccounts;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public ImmutableList<String> getTargetServiceAccounts() {
        return this.targetServiceAccounts;
    }

    public static final class Builder {
        @Nullable
        private String targetName;
        @Nullable
        private RpcProtocolVersions rpcProtocolVersions;
        private ImmutableList<String> targetServiceAccounts = ImmutableList.of();

        public Builder setTargetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public Builder setRpcProtocolVersions(RpcProtocolVersions rpcProtocolVersions) {
            this.rpcProtocolVersions = rpcProtocolVersions;
            return this;
        }

        public Builder setTargetServiceAccounts(ImmutableList<String> targetServiceAccounts) {
            this.targetServiceAccounts = targetServiceAccounts;
            return this;
        }

        public AltsClientOptions build() {
            return new AltsClientOptions(this);
        }
    }
}

