/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.alts.internal;

import java.util.Map;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.io.grpc.alts.internal.AltsContext;
import shaded.bqjdbc.io.grpc.alts.internal.HandshakerResult;
import shaded.bqjdbc.io.grpc.alts.internal.RpcProtocolVersions;
import shaded.bqjdbc.io.grpc.alts.internal.SecurityLevel;

public final class AltsInternalContext {
    final AltsContext context;

    public AltsInternalContext(HandshakerResult result) {
        this.context = AltsContext.newBuilder().setApplicationProtocol(result.getApplicationProtocol()).setRecordProtocol(result.getRecordProtocol()).setSecurityLevel(SecurityLevel.INTEGRITY_AND_PRIVACY).setPeerServiceAccount(result.getPeerIdentity().getServiceAccount()).setLocalServiceAccount(result.getLocalIdentity().getServiceAccount()).setPeerRpcVersions(result.getPeerRpcVersions()).putAllPeerAttributes(result.getPeerIdentity().getAttributesMap()).build();
    }

    @VisibleForTesting
    public static AltsInternalContext getDefaultInstance() {
        return new AltsInternalContext(HandshakerResult.newBuilder().build());
    }

    public String getApplicationProtocol() {
        return this.context.getApplicationProtocol();
    }

    public String getRecordProtocol() {
        return this.context.getRecordProtocol();
    }

    public SecurityLevel getSecurityLevel() {
        return this.context.getSecurityLevel();
    }

    public String getPeerServiceAccount() {
        return this.context.getPeerServiceAccount();
    }

    public String getLocalServiceAccount() {
        return this.context.getLocalServiceAccount();
    }

    public RpcProtocolVersions getPeerRpcVersions() {
        return this.context.getPeerRpcVersions();
    }

    public Map<String, String> getPeerAttributes() {
        return this.context.getPeerAttributesMap();
    }
}

