/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.googleapis;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.io.grpc.Internal;
import shaded.bqjdbc.io.grpc.NameResolver;
import shaded.bqjdbc.io.grpc.NameResolverProvider;
import shaded.bqjdbc.io.grpc.googleapis.GoogleCloudToProdNameResolver;
import shaded.bqjdbc.io.grpc.internal.GrpcUtil;
import shaded.bqjdbc.io.grpc.xds.InternalSharedXdsClientPoolProvider;

@Internal
public final class GoogleCloudToProdNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "google-c2p";
    private final String scheme;

    public GoogleCloudToProdNameResolverProvider() {
        this(SCHEME);
    }

    GoogleCloudToProdNameResolverProvider(String scheme) {
        this.scheme = Preconditions.checkNotNull(scheme, "scheme");
    }

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (this.scheme.equals(targetUri.getScheme())) {
            return new GoogleCloudToProdNameResolver(targetUri, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, new SharedXdsClientPoolProviderBootstrapSetter());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return this.scheme;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 4;
    }

    @Override
    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }

    private static final class SharedXdsClientPoolProviderBootstrapSetter
    implements GoogleCloudToProdNameResolver.BootstrapSetter {
        private SharedXdsClientPoolProviderBootstrapSetter() {
        }

        @Override
        public void setBootstrap(Map<String, ?> bootstrap) {
            InternalSharedXdsClientPoolProvider.setDefaultProviderBootstrapOverride(bootstrap);
        }
    }
}

