/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.grpclb;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.base.Stopwatch;
import shaded.bqjdbc.io.grpc.InternalServiceProviders;
import shaded.bqjdbc.io.grpc.NameResolver;
import shaded.bqjdbc.io.grpc.NameResolverProvider;
import shaded.bqjdbc.io.grpc.grpclb.GrpclbNameResolver;
import shaded.bqjdbc.io.grpc.internal.GrpcUtil;

final class SecretGrpclbNameResolverProvider {
    private SecretGrpclbNameResolverProvider() {
    }

    public static final class Provider
    extends NameResolverProvider {
        private static final String SCHEME = "dns";
        private static final boolean IS_ANDROID = InternalServiceProviders.isAndroid(SecretGrpclbNameResolverProvider.class.getClassLoader());

        @Override
        public GrpclbNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
            if (SCHEME.equals(targetUri.getScheme())) {
                String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
                Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
                String name = targetPath.substring(1);
                return new GrpclbNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), IS_ANDROID);
            }
            return null;
        }

        @Override
        public String getDefaultScheme() {
            return SCHEME;
        }

        @Override
        protected boolean isAvailable() {
            return true;
        }

        @Override
        public int priority() {
            return 6;
        }

        @Override
        public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
            return Collections.singleton(InetSocketAddress.class);
        }
    }
}

