/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.inprocess;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.errorprone.annotations.concurrent.GuardedBy;
import shaded.bqjdbc.io.grpc.ExperimentalApi;
import shaded.bqjdbc.io.grpc.inprocess.InProcessServer;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8626")
public final class AnonymousInProcessSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = -8567592561863414695L;
    @Nullable
    @GuardedBy(value="this")
    private InProcessServer server;

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("AnonymousInProcessSocketAddress is not serializable");
    }

    @Nullable
    synchronized InProcessServer getServer() {
        return this.server;
    }

    synchronized void setServer(InProcessServer server) throws IOException {
        if (this.server != null) {
            throw new IOException("Server instance already registered");
        }
        this.server = server;
    }

    synchronized void clearServer(InProcessServer server) {
        Preconditions.checkState(this.server == server);
        this.server = null;
    }
}

