/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.internal;

import java.util.concurrent.Executor;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.util.concurrent.ListenableFuture;
import shaded.bqjdbc.com.google.common.util.concurrent.SettableFuture;
import shaded.bqjdbc.io.grpc.CallOptions;
import shaded.bqjdbc.io.grpc.ClientStreamTracer;
import shaded.bqjdbc.io.grpc.InternalChannelz;
import shaded.bqjdbc.io.grpc.InternalLogId;
import shaded.bqjdbc.io.grpc.Metadata;
import shaded.bqjdbc.io.grpc.MethodDescriptor;
import shaded.bqjdbc.io.grpc.Status;
import shaded.bqjdbc.io.grpc.internal.ClientStream;
import shaded.bqjdbc.io.grpc.internal.ClientStreamListener;
import shaded.bqjdbc.io.grpc.internal.ClientTransport;
import shaded.bqjdbc.io.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error);
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

