/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.grpc.netty.shaded.io.netty.handler.codec.socks;

import java.nio.charset.CharsetEncoder;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksRequest;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksRequestType;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.handler.codec.socks.SocksSubnegotiationVersion;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import shaded.bqjdbc.io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class SocksAuthRequest
extends SocksRequest {
    private static final SocksSubnegotiationVersion SUBNEGOTIATION_VERSION = SocksSubnegotiationVersion.AUTH_PASSWORD;
    private final String username;
    private final String password;

    public SocksAuthRequest(String username, String password) {
        super(SocksRequestType.AUTH);
        ObjectUtil.checkNotNull(username, "username");
        ObjectUtil.checkNotNull(password, "password");
        CharsetEncoder asciiEncoder = CharsetUtil.encoder(CharsetUtil.US_ASCII);
        if (!asciiEncoder.canEncode(username) || !asciiEncoder.canEncode(password)) {
            throw new IllegalArgumentException("username: " + username + " or password: **** values should be in pure ascii");
        }
        if (username.length() > 255) {
            throw new IllegalArgumentException("username: " + username + " exceeds 255 char limit");
        }
        if (password.length() > 255) {
            throw new IllegalArgumentException("password: **** exceeds 255 char limit");
        }
        this.username = username;
        this.password = password;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(SUBNEGOTIATION_VERSION.byteValue());
        byteBuf.writeByte(this.username.length());
        byteBuf.writeCharSequence(this.username, CharsetUtil.US_ASCII);
        byteBuf.writeByte(this.password.length());
        byteBuf.writeCharSequence(this.password, CharsetUtil.US_ASCII);
    }
}

