/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Arrays;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;
import shaded.bqjdbc.io.netty.buffer.AbstractByteBuf;
import shaded.bqjdbc.io.netty.buffer.AbstractReferenceCountedByteBuf;
import shaded.bqjdbc.io.netty.buffer.ByteBuf;
import shaded.bqjdbc.io.netty.buffer.ByteBufAllocator;
import shaded.bqjdbc.io.netty.buffer.ByteBufUtil;
import shaded.bqjdbc.io.netty.buffer.UnpooledDuplicatedByteBuf;
import shaded.bqjdbc.io.netty.buffer.UnpooledSlicedByteBuf;
import shaded.bqjdbc.io.netty.util.ByteProcessor;
import shaded.bqjdbc.io.netty.util.NettyRuntime;
import shaded.bqjdbc.io.netty.util.Recycler;
import shaded.bqjdbc.io.netty.util.ReferenceCounted;
import shaded.bqjdbc.io.netty.util.concurrent.FastThreadLocal;
import shaded.bqjdbc.io.netty.util.concurrent.FastThreadLocalThread;
import shaded.bqjdbc.io.netty.util.internal.ObjectPool;
import shaded.bqjdbc.io.netty.util.internal.ObjectUtil;
import shaded.bqjdbc.io.netty.util.internal.PlatformDependent;
import shaded.bqjdbc.io.netty.util.internal.SuppressJava6Requirement;
import shaded.bqjdbc.io.netty.util.internal.SystemPropertyUtil;
import shaded.bqjdbc.io.netty.util.internal.ThreadExecutorMap;

@SuppressJava6Requirement(reason="Guarded by version check")
final class AdaptivePoolingAllocator {
    private static final int EXPANSION_ATTEMPTS = 3;
    private static final int INITIAL_MAGAZINES = 4;
    private static final int RETIRE_CAPACITY = 4096;
    private static final int MIN_CHUNK_SIZE = 131072;
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() * 2;
    private static final int BUFS_PER_CHUNK = 10;
    private static final int MAX_CHUNK_SIZE = 0xA00000;
    private static final int CENTRAL_QUEUE_CAPACITY = SystemPropertyUtil.getInt("shaded.bqjdbc.io.netty.allocator.centralQueueCapacity", NettyRuntime.availableProcessors());
    private static final Object NO_MAGAZINE = Boolean.TRUE;
    private final ChunkAllocator chunkAllocator;
    private final Queue<Chunk> centralQueue;
    private final StampedLock magazineExpandLock;
    private volatile Magazine[] magazines;
    private final FastThreadLocal<Object> threadLocalMagazine;
    private final Set<Magazine> liveCachedMagazines;

    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, MagazineCaching magazineCaching) {
        ObjectUtil.checkNotNull(chunkAllocator, "chunkAllocator");
        ObjectUtil.checkNotNull(magazineCaching, "magazineCaching");
        this.chunkAllocator = chunkAllocator;
        if (PlatformDependent.javaVersion() < 8) {
            throw new IllegalStateException("This allocator require Java 8 or newer.");
        }
        this.centralQueue = ObjectUtil.checkNotNull(AdaptivePoolingAllocator.createSharedChunkQueue(), "centralQueue");
        this.magazineExpandLock = new StampedLock();
        if (magazineCaching != MagazineCaching.None) {
            assert (magazineCaching == MagazineCaching.EventLoopThreads || magazineCaching == MagazineCaching.FastThreadLocalThreads);
            final boolean cachedMagazinesNonEventLoopThreads = magazineCaching == MagazineCaching.FastThreadLocalThreads;
            final CopyOnWriteArraySet<Magazine> liveMagazines = new CopyOnWriteArraySet<Magazine>();
            this.threadLocalMagazine = new FastThreadLocal<Object>(){

                @Override
                protected Object initialValue() {
                    if (cachedMagazinesNonEventLoopThreads || ThreadExecutorMap.currentExecutor() != null) {
                        Magazine mag = new Magazine(AdaptivePoolingAllocator.this, false);
                        liveMagazines.add(mag);
                        return mag;
                    }
                    return NO_MAGAZINE;
                }

                @Override
                protected void onRemoval(Object value) throws Exception {
                    if (value != NO_MAGAZINE) {
                        liveMagazines.remove(value);
                    }
                }
            };
            this.liveCachedMagazines = liveMagazines;
        } else {
            this.threadLocalMagazine = null;
            this.liveCachedMagazines = null;
        }
        Magazine[] mags = new Magazine[4];
        for (int i = 0; i < mags.length; ++i) {
            mags[i] = new Magazine(this);
        }
        this.magazines = mags;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue(CENTRAL_QUEUE_CAPACITY);
    }

    ByteBuf allocate(int size, int maxCapacity) {
        if (size <= 0xA00000) {
            boolean willCleanupFastThreadLocals;
            AdaptiveByteBuf buf;
            Thread currentThread = Thread.currentThread();
            AdaptiveByteBuf result = this.allocate(size, maxCapacity, currentThread, buf = AdaptiveByteBuf.newInstance(willCleanupFastThreadLocals = FastThreadLocalThread.willCleanupFastThreadLocals(currentThread)));
            if (result != null) {
                return result;
            }
            buf.release();
        }
        return this.chunkAllocator.allocate(size, maxCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptiveByteBuf allocate(int size, int maxCapacity, Thread currentThread, AdaptiveByteBuf buf) {
        Magazine[] mags;
        Object mag;
        int sizeBucket = AllocationStatistics.sizeBucket(size);
        FastThreadLocal<Object> threadLocalMagazine = this.threadLocalMagazine;
        if (threadLocalMagazine != null && currentThread instanceof FastThreadLocalThread && (mag = threadLocalMagazine.get()) != NO_MAGAZINE) {
            return ((Magazine)mag).allocate(size, sizeBucket, maxCapacity, buf);
        }
        long threadId = currentThread.getId();
        int expansions = 0;
        do {
            mags = this.magazines;
            int mask = mags.length - 1;
            int index = (int)(threadId & (long)mask);
            int m4 = Integer.numberOfTrailingZeros(~mask);
            for (int i = 0; i < m4; ++i) {
                Magazine mag2 = mags[index + i & mask];
                long writeLock = mag2.tryWriteLock();
                if (writeLock == 0L) continue;
                try {
                    AdaptiveByteBuf adaptiveByteBuf = mag2.allocate(size, sizeBucket, maxCapacity, buf);
                    return adaptiveByteBuf;
                }
                finally {
                    mag2.unlockWrite(writeLock);
                }
            }
        } while (++expansions <= 3 && this.tryExpandMagazines(mags.length));
        return null;
    }

    void allocate(int size, int maxCapacity, AdaptiveByteBuf into) {
        Magazine magazine = into.chunk.magazine;
        AdaptiveByteBuf result = this.allocate(size, maxCapacity, Thread.currentThread(), into);
        if (result == null) {
            AbstractByteBuf innerChunk = (AbstractByteBuf)this.chunkAllocator.allocate(size, maxCapacity);
            Chunk chunk = new Chunk(innerChunk, magazine, false);
            chunk.readInitInto(into, size, maxCapacity);
        }
    }

    long usedMemory() {
        long sum = 0L;
        for (Chunk chunk : this.centralQueue) {
            sum += (long)chunk.capacity();
        }
        for (Magazine magazine : this.magazines) {
            sum += magazine.usedMemory.get();
        }
        if (this.liveCachedMagazines != null) {
            for (Magazine magazine : this.liveCachedMagazines) {
                sum += magazine.usedMemory.get();
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExpandMagazines(int currentLength) {
        if (currentLength >= MAX_STRIPES) {
            return true;
        }
        long writeLock = this.magazineExpandLock.tryWriteLock();
        if (writeLock != 0L) {
            try {
                Magazine[] mags = this.magazines;
                if (mags.length >= MAX_STRIPES || mags.length > currentLength) {
                    boolean bl = true;
                    return bl;
                }
                Magazine[] expanded = Arrays.copyOf(mags, mags.length * 2);
                int m4 = expanded.length;
                for (int i = mags.length; i < m4; ++i) {
                    expanded[i] = new Magazine(this);
                }
                this.magazines = expanded;
            }
            finally {
                this.magazineExpandLock.unlockWrite(writeLock);
            }
        }
        return true;
    }

    private boolean offerToQueue(Chunk buffer) {
        return this.centralQueue.offer(buffer);
    }

    public static interface ChunkAllocator {
        public ByteBuf allocate(int var1, int var2);
    }

    private static final class PooledNonRetainedSlicedByteBuf
    extends UnpooledSlicedByteBuf {
        private final ReferenceCounted referenceCountDelegate;

        PooledNonRetainedSlicedByteBuf(ReferenceCounted referenceCountDelegate, AbstractByteBuf buffer, int index, int length) {
            super(buffer, index, length);
            this.referenceCountDelegate = referenceCountDelegate;
        }

        @Override
        boolean isAccessible0() {
            return this.referenceCountDelegate.refCnt() != 0;
        }

        @Override
        int refCnt0() {
            return this.referenceCountDelegate.refCnt();
        }

        @Override
        ByteBuf retain0() {
            this.referenceCountDelegate.retain();
            return this;
        }

        @Override
        ByteBuf retain0(int increment) {
            this.referenceCountDelegate.retain(increment);
            return this;
        }

        @Override
        ByteBuf touch0() {
            this.referenceCountDelegate.touch();
            return this;
        }

        @Override
        ByteBuf touch0(Object hint) {
            this.referenceCountDelegate.touch(hint);
            return this;
        }

        @Override
        boolean release0() {
            return this.referenceCountDelegate.release();
        }

        @Override
        boolean release0(int decrement) {
            return this.referenceCountDelegate.release(decrement);
        }

        @Override
        public ByteBuf duplicate() {
            this.ensureAccessible();
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), this.idx(0), this.capacity()).setIndex(this.readerIndex(), this.writerIndex());
        }

        @Override
        public ByteBuf retainedDuplicate() {
            return this.duplicate().retain();
        }

        @Override
        public ByteBuf slice(int index, int length) {
            this.checkIndex(index, length);
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), this.idx(index), length);
        }

        @Override
        public ByteBuf retainedSlice() {
            return this.retainedSlice(0, this.capacity());
        }

        @Override
        public ByteBuf retainedSlice(int index, int length) {
            return this.slice(index, length).retain();
        }
    }

    private static final class PooledNonRetainedDuplicateByteBuf
    extends UnpooledDuplicatedByteBuf {
        private final ReferenceCounted referenceCountDelegate;

        PooledNonRetainedDuplicateByteBuf(ReferenceCounted referenceCountDelegate, AbstractByteBuf buffer) {
            super(buffer);
            this.referenceCountDelegate = referenceCountDelegate;
        }

        @Override
        boolean isAccessible0() {
            return this.referenceCountDelegate.refCnt() != 0;
        }

        @Override
        int refCnt0() {
            return this.referenceCountDelegate.refCnt();
        }

        @Override
        ByteBuf retain0() {
            this.referenceCountDelegate.retain();
            return this;
        }

        @Override
        ByteBuf retain0(int increment) {
            this.referenceCountDelegate.retain(increment);
            return this;
        }

        @Override
        ByteBuf touch0() {
            this.referenceCountDelegate.touch();
            return this;
        }

        @Override
        ByteBuf touch0(Object hint) {
            this.referenceCountDelegate.touch(hint);
            return this;
        }

        @Override
        boolean release0() {
            return this.referenceCountDelegate.release();
        }

        @Override
        boolean release0(int decrement) {
            return this.referenceCountDelegate.release(decrement);
        }

        @Override
        public ByteBuf duplicate() {
            this.ensureAccessible();
            return new PooledNonRetainedDuplicateByteBuf(this.referenceCountDelegate, this.unwrap());
        }

        @Override
        public ByteBuf retainedDuplicate() {
            return this.duplicate().retain();
        }

        @Override
        public ByteBuf slice(int index, int length) {
            this.checkIndex(index, length);
            return new PooledNonRetainedSlicedByteBuf(this.referenceCountDelegate, this.unwrap(), index, length);
        }

        @Override
        public ByteBuf retainedSlice() {
            return this.retainedSlice(this.readerIndex(), this.capacity());
        }

        @Override
        public ByteBuf retainedSlice(int index, int length) {
            return this.slice(index, length).retain();
        }
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        static final ObjectPool<AdaptiveByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<AdaptiveByteBuf>(){

            @Override
            public AdaptiveByteBuf newObject(ObjectPool.Handle<AdaptiveByteBuf> handle) {
                return new AdaptiveByteBuf(handle);
            }
        });
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        int adjustment;
        private AbstractByteBuf rootParent;
        private Chunk chunk;
        private int length;
        private ByteBuffer tmpNioBuf;

        static AdaptiveByteBuf newInstance(boolean useThreadLocal) {
            if (useThreadLocal) {
                AdaptiveByteBuf buf = RECYCLER.get();
                buf.resetRefCnt();
                buf.discardMarks();
                return buf;
            }
            return new AdaptiveByteBuf(null);
        }

        AdaptiveByteBuf(ObjectPool.Handle<AdaptiveByteBuf> recyclerHandle) {
            super(0);
            this.handle = recyclerHandle;
        }

        void init(AbstractByteBuf unwrapped, Chunk wrapped, int readerIndex, int writerIndex, int adjustment, int capacity, int maxCapacity) {
            this.adjustment = adjustment;
            this.chunk = wrapped;
            this.length = capacity;
            this.maxCapacity(maxCapacity);
            this.setIndex0(readerIndex, writerIndex);
            this.rootParent = unwrapped;
            this.tmpNioBuf = this.rootParent.internalNioBuffer(adjustment, capacity).slice();
        }

        @Override
        public int capacity() {
            return this.length;
        }

        @Override
        public ByteBuf capacity(int newCapacity) {
            if (newCapacity == this.capacity()) {
                this.ensureAccessible();
                return this;
            }
            this.checkNewCapacity(newCapacity);
            if (newCapacity < this.capacity()) {
                this.length = newCapacity;
                this.setIndex0(Math.min(this.readerIndex(), newCapacity), Math.min(this.writerIndex(), newCapacity));
                return this;
            }
            ByteBuffer data = this.tmpNioBuf;
            data.clear();
            this.tmpNioBuf = null;
            Chunk chunk = this.chunk;
            Magazine magazine = chunk.magazine;
            AdaptivePoolingAllocator allocator = magazine.parent;
            int readerIndex = this.readerIndex;
            int writerIndex = this.writerIndex;
            allocator.allocate(newCapacity, this.maxCapacity(), this);
            this.tmpNioBuf.put(data);
            this.tmpNioBuf.clear();
            chunk.release();
            this.readerIndex = readerIndex;
            this.writerIndex = writerIndex;
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.rootParent.alloc();
        }

        @Override
        public ByteOrder order() {
            return this.rootParent.order();
        }

        @Override
        public ByteBuf unwrap() {
            return null;
        }

        @Override
        public boolean isDirect() {
            return this.rootParent.isDirect();
        }

        @Override
        public int arrayOffset() {
            return this.idx(this.rootParent.arrayOffset());
        }

        @Override
        public boolean hasMemoryAddress() {
            return this.rootParent.hasMemoryAddress();
        }

        @Override
        public long memoryAddress() {
            this.ensureAccessible();
            return this.rootParent.memoryAddress() + (long)this.adjustment;
        }

        @Override
        public ByteBuffer nioBuffer(int index, int length) {
            this.checkIndex(index, length);
            return this.rootParent.nioBuffer(this.idx(index), length);
        }

        @Override
        public ByteBuffer internalNioBuffer(int index, int length) {
            this.checkIndex(index, length);
            return (ByteBuffer)this.internalNioBuffer().position(index).limit(index + length);
        }

        private ByteBuffer internalNioBuffer() {
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        @Override
        public ByteBuffer[] nioBuffers(int index, int length) {
            this.checkIndex(index, length);
            return this.rootParent.nioBuffers(this.idx(index), length);
        }

        @Override
        public boolean hasArray() {
            return this.rootParent.hasArray();
        }

        @Override
        public byte[] array() {
            return this.rootParent.array();
        }

        @Override
        public ByteBuf copy(int index, int length) {
            this.checkIndex(index, length);
            return this.rootParent.copy(this.idx(index), length);
        }

        @Override
        public ByteBuf slice(int index, int length) {
            this.checkIndex(index, length);
            return new PooledNonRetainedSlicedByteBuf(this, this.rootParent, this.idx(index), length);
        }

        @Override
        public ByteBuf retainedSlice(int index, int length) {
            return this.slice(index, length).retain();
        }

        @Override
        public ByteBuf duplicate() {
            this.ensureAccessible();
            return new PooledNonRetainedDuplicateByteBuf(this, this).setIndex(this.readerIndex(), this.writerIndex());
        }

        @Override
        public ByteBuf retainedDuplicate() {
            return this.duplicate().retain();
        }

        @Override
        public int nioBufferCount() {
            return this.rootParent.nioBufferCount();
        }

        @Override
        public byte getByte(int index) {
            this.checkIndex(index, 1);
            return this.rootParent.getByte(this.idx(index));
        }

        @Override
        protected byte _getByte(int index) {
            return this.rootParent._getByte(this.idx(index));
        }

        @Override
        public short getShort(int index) {
            this.checkIndex(index, 2);
            return this.rootParent.getShort(this.idx(index));
        }

        @Override
        protected short _getShort(int index) {
            return this.rootParent._getShort(this.idx(index));
        }

        @Override
        public short getShortLE(int index) {
            this.checkIndex(index, 2);
            return this.rootParent.getShortLE(this.idx(index));
        }

        @Override
        protected short _getShortLE(int index) {
            return this.rootParent._getShortLE(this.idx(index));
        }

        @Override
        public int getUnsignedMedium(int index) {
            this.checkIndex(index, 3);
            return this.rootParent.getUnsignedMedium(this.idx(index));
        }

        @Override
        protected int _getUnsignedMedium(int index) {
            return this.rootParent._getUnsignedMedium(this.idx(index));
        }

        @Override
        public int getUnsignedMediumLE(int index) {
            this.checkIndex(index, 3);
            return this.rootParent.getUnsignedMediumLE(this.idx(index));
        }

        @Override
        protected int _getUnsignedMediumLE(int index) {
            return this.rootParent._getUnsignedMediumLE(this.idx(index));
        }

        @Override
        public int getInt(int index) {
            this.checkIndex(index, 4);
            return this.rootParent.getInt(this.idx(index));
        }

        @Override
        protected int _getInt(int index) {
            return this.rootParent._getInt(this.idx(index));
        }

        @Override
        public int getIntLE(int index) {
            this.checkIndex(index, 4);
            return this.rootParent.getIntLE(this.idx(index));
        }

        @Override
        protected int _getIntLE(int index) {
            return this.rootParent._getIntLE(this.idx(index));
        }

        @Override
        public long getLong(int index) {
            this.checkIndex(index, 8);
            return this.rootParent.getLong(this.idx(index));
        }

        @Override
        protected long _getLong(int index) {
            return this.rootParent._getLong(this.idx(index));
        }

        @Override
        public long getLongLE(int index) {
            this.checkIndex(index, 8);
            return this.rootParent.getLongLE(this.idx(index));
        }

        @Override
        protected long _getLongLE(int index) {
            return this.rootParent._getLongLE(this.idx(index));
        }

        @Override
        public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent.getBytes(this.idx(index), dst, dstIndex, length);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent.getBytes(this.idx(index), dst, dstIndex, length);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index, ByteBuffer dst) {
            this.checkIndex(index, dst.remaining());
            this.rootParent.getBytes(this.idx(index), dst);
            return this;
        }

        @Override
        public ByteBuf setByte(int index, int value) {
            this.checkIndex(index, 1);
            this.rootParent.setByte(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setByte(int index, int value) {
            this.rootParent._setByte(this.idx(index), value);
        }

        @Override
        public ByteBuf setShort(int index, int value) {
            this.checkIndex(index, 2);
            this.rootParent.setShort(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setShort(int index, int value) {
            this.rootParent._setShort(this.idx(index), value);
        }

        @Override
        public ByteBuf setShortLE(int index, int value) {
            this.checkIndex(index, 2);
            this.rootParent.setShortLE(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setShortLE(int index, int value) {
            this.rootParent._setShortLE(this.idx(index), value);
        }

        @Override
        public ByteBuf setMedium(int index, int value) {
            this.checkIndex(index, 3);
            this.rootParent.setMedium(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setMedium(int index, int value) {
            this.rootParent._setMedium(this.idx(index), value);
        }

        @Override
        public ByteBuf setMediumLE(int index, int value) {
            this.checkIndex(index, 3);
            this.rootParent.setMediumLE(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setMediumLE(int index, int value) {
            this.rootParent._setMediumLE(this.idx(index), value);
        }

        @Override
        public ByteBuf setInt(int index, int value) {
            this.checkIndex(index, 4);
            this.rootParent.setInt(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setInt(int index, int value) {
            this.rootParent._setInt(this.idx(index), value);
        }

        @Override
        public ByteBuf setIntLE(int index, int value) {
            this.checkIndex(index, 4);
            this.rootParent.setIntLE(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setIntLE(int index, int value) {
            this.rootParent._setIntLE(this.idx(index), value);
        }

        @Override
        public ByteBuf setLong(int index, long value) {
            this.checkIndex(index, 8);
            this.rootParent.setLong(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setLong(int index, long value) {
            this.rootParent._setLong(this.idx(index), value);
        }

        @Override
        public ByteBuf setLongLE(int index, long value) {
            this.checkIndex(index, 8);
            this.rootParent.setLongLE(this.idx(index), value);
            return this;
        }

        @Override
        protected void _setLongLE(int index, long value) {
            this.rootParent.setLongLE(this.idx(index), value);
        }

        @Override
        public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent.setBytes(this.idx(index), src, srcIndex, length);
            return this;
        }

        @Override
        public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent.setBytes(this.idx(index), src, srcIndex, length);
            return this;
        }

        @Override
        public ByteBuf setBytes(int index, ByteBuffer src) {
            this.checkIndex(index, src.remaining());
            this.rootParent.setBytes(this.idx(index), src);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
            this.checkIndex(index, length);
            if (length != 0) {
                ByteBufUtil.readBytes(this.alloc(), this.internalNioBuffer().duplicate(), index, length, out);
            }
            return this;
        }

        @Override
        public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
            return out.write(this.internalNioBuffer(index, length).duplicate());
        }

        @Override
        public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
            return out.write(this.internalNioBuffer(index, length).duplicate(), position);
        }

        @Override
        public int setBytes(int index, InputStream in, int length) throws IOException {
            this.checkIndex(index, length);
            if (this.rootParent.hasArray()) {
                return this.rootParent.setBytes(this.idx(index), in, length);
            }
            byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
            int readBytes = in.read(tmp, 0, length);
            if (readBytes <= 0) {
                return readBytes;
            }
            this.setBytes(index, tmp, 0, readBytes);
            return readBytes;
        }

        @Override
        public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
            try {
                return in.read(this.internalNioBuffer(index, length).duplicate());
            }
            catch (ClosedChannelException ignored) {
                return -1;
            }
        }

        @Override
        public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
            try {
                return in.read(this.internalNioBuffer(index, length).duplicate(), position);
            }
            catch (ClosedChannelException ignored) {
                return -1;
            }
        }

        @Override
        public int forEachByte(int index, int length, ByteProcessor processor) {
            this.checkIndex(index, length);
            int ret = this.rootParent.forEachByte(this.idx(index), length, processor);
            if (ret < this.adjustment) {
                return -1;
            }
            return ret - this.adjustment;
        }

        @Override
        public int forEachByteDesc(int index, int length, ByteProcessor processor) {
            this.checkIndex(index, length);
            int ret = this.rootParent.forEachByteDesc(this.idx(index), length, processor);
            if (ret < this.adjustment) {
                return -1;
            }
            return ret - this.adjustment;
        }

        @Override
        public boolean isContiguous() {
            return this.rootParent.isContiguous();
        }

        private int idx(int index) {
            return index + this.adjustment;
        }

        @Override
        protected void deallocate() {
            this.tmpNioBuf = null;
            if (this.chunk != null) {
                this.chunk.release();
            }
            if (this.handle instanceof Recycler.EnhancedHandle) {
                ((Recycler.EnhancedHandle)this.handle).unguardedRecycle(this);
            } else if (this.handle != null) {
                this.handle.recycle(this);
            }
        }
    }

    private static final class Chunk {
        private static final AtomicIntegerFieldUpdater<Chunk> REF_CNT_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCntUp");
        private static final AtomicIntegerFieldUpdater<Chunk> REF_CNT_DOWN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCntDown");
        private final AbstractByteBuf delegate;
        private final Magazine magazine;
        private final int capacity;
        private final boolean pooled;
        private int allocatedBytes;
        private volatile int refCntUp;
        private volatile int refCntDown;

        Chunk(AbstractByteBuf delegate, Magazine magazine, boolean pooled) {
            this.delegate = delegate;
            this.magazine = magazine;
            this.pooled = pooled;
            this.capacity = delegate.capacity();
            magazine.usedMemory.getAndAdd(this.capacity);
            REF_CNT_UP_UPDATER.lazySet(this, 1);
        }

        protected void deallocate() {
            Magazine mag = this.magazine;
            AdaptivePoolingAllocator parent = mag.parent;
            int chunkSize = mag.preferredChunkSize();
            int memSize = this.delegate.capacity();
            if (!this.pooled || memSize < chunkSize || memSize > chunkSize + (chunkSize >> 1)) {
                mag.usedMemory.getAndAdd(-this.capacity());
                this.delegate.release();
            } else {
                REF_CNT_UP_UPDATER.lazySet(this, 1);
                REF_CNT_DOWN_UPDATER.lazySet(this, 0);
                this.delegate.setIndex(0, 0);
                this.allocatedBytes = 0;
                if (!mag.trySetNextInLine(this) && !parent.offerToQueue(this)) {
                    this.delegate.release();
                }
            }
        }

        public AdaptiveByteBuf readInitInto(AdaptiveByteBuf buf, int size, int maxCapacity) {
            int startIndex = this.allocatedBytes;
            this.allocatedBytes = startIndex + size;
            this.unguardedRetain();
            buf.init(this.delegate, this, 0, 0, startIndex, size, maxCapacity);
            return buf;
        }

        public int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }

        public int capacity() {
            return this.capacity;
        }

        private void unguardedRetain() {
            REF_CNT_UP_UPDATER.lazySet(this, this.refCntUp + 1);
        }

        public void release() {
            boolean deallocate;
            int refCntDown;
            do {
                int refCntUp;
                int remaining;
                if ((remaining = (refCntUp = this.refCntUp) - (refCntDown = this.refCntDown)) <= 0) {
                    throw new IllegalStateException("RefCnt is already 0");
                }
                boolean bl = deallocate = remaining == 1;
            } while (!REF_CNT_DOWN_UPDATER.compareAndSet(this, refCntDown, refCntDown + 1));
            if (deallocate) {
                this.deallocate();
            }
        }
    }

    private static final class Magazine
    extends AllocationStatistics {
        private static final long serialVersionUID = -4068223712022528165L;
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private Chunk current;
        private volatile Chunk nextInLine;
        private final AtomicLong usedMemory = new AtomicLong();

        Magazine(AdaptivePoolingAllocator parent) {
            this(parent, true);
        }

        Magazine(AdaptivePoolingAllocator parent, boolean shareable) {
            super(parent, shareable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AdaptiveByteBuf allocate(int size, int sizeBucket, int maxCapacity, AdaptiveByteBuf buf) {
            AdaptiveByteBuf result;
            this.recordAllocationSize(sizeBucket);
            Chunk curr = this.current;
            if (curr != null && curr.remainingCapacity() >= size) {
                if (curr.remainingCapacity() == size) {
                    this.current = null;
                    try {
                        AdaptiveByteBuf adaptiveByteBuf = curr.readInitInto(buf, size, maxCapacity);
                        return adaptiveByteBuf;
                    }
                    finally {
                        curr.release();
                    }
                }
                return curr.readInitInto(buf, size, maxCapacity);
            }
            if (curr != null) {
                curr.release();
            }
            if (this.nextInLine != null) {
                curr = NEXT_IN_LINE.getAndSet(this, null);
            } else {
                curr = (Chunk)this.parent.centralQueue.poll();
                if (curr == null) {
                    curr = this.newChunkAllocation(size);
                }
            }
            this.current = curr;
            if (curr.remainingCapacity() > size) {
                result = curr.readInitInto(buf, size, maxCapacity);
            } else if (curr.remainingCapacity() == size) {
                result = curr.readInitInto(buf, size, maxCapacity);
                curr.release();
                this.current = null;
            } else {
                Chunk newChunk = this.newChunkAllocation(size);
                result = newChunk.readInitInto(buf, size, maxCapacity);
                if (curr.remainingCapacity() < 4096) {
                    curr.release();
                    this.current = newChunk;
                } else if (!NEXT_IN_LINE.compareAndSet(this, null, newChunk) && !this.parent.offerToQueue(newChunk)) {
                    newChunk.release();
                }
            }
            return result;
        }

        private Chunk newChunkAllocation(int promptingSize) {
            int size = Math.max(promptingSize * 10, this.preferredChunkSize());
            ChunkAllocator chunkAllocator = this.parent.chunkAllocator;
            Chunk chunk = new Chunk((AbstractByteBuf)chunkAllocator.allocate(size, size), this, true);
            return chunk;
        }

        boolean trySetNextInLine(Chunk buffer) {
            return NEXT_IN_LINE.compareAndSet(this, null, buffer);
        }
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    private static class AllocationStatistics
    extends StampedLock {
        private static final long serialVersionUID = -8319929980932269688L;
        private static final int MIN_DATUM_TARGET = 1024;
        private static final int MAX_DATUM_TARGET = 65534;
        private static final int INIT_DATUM_TARGET = 8192;
        private static final int HISTO_MIN_BUCKET_SHIFT = 13;
        private static final int HISTO_MAX_BUCKET_SHIFT = 20;
        private static final int HISTO_BUCKET_COUNT = 8;
        private static final int HISTO_MAX_BUCKET_MASK = 7;
        protected final AdaptivePoolingAllocator parent;
        private final boolean shareable;
        private final short[][] histos = new short[][]{new short[8], new short[8], new short[8], new short[8]};
        private short[] histo = this.histos[0];
        private final int[] sums = new int[8];
        private int histoIndex;
        private int datumCount;
        private int datumTarget = 8192;
        private volatile int sharedPrefChunkSize = 131072;
        protected volatile int localPrefChunkSize = 131072;

        private AllocationStatistics(AdaptivePoolingAllocator parent, boolean shareable) {
            this.parent = parent;
            this.shareable = shareable;
        }

        protected void recordAllocationSize(int bucket) {
            int n = bucket;
            this.histo[n] = (short)(this.histo[n] + 1);
            if (this.datumCount++ == this.datumTarget) {
                this.rotateHistograms();
            }
        }

        static int sizeBucket(int size) {
            int normalizedSize = size - 1 >> 13 & 7;
            return 32 - Integer.numberOfLeadingZeros(normalizedSize);
        }

        private void rotateHistograms() {
            int prefChunkSize;
            int sizeBucket;
            short[][] hs = this.histos;
            for (int i = 0; i < 8; ++i) {
                this.sums[i] = (hs[0][i] & 0xFFFF) + (hs[1][i] & 0xFFFF) + (hs[2][i] & 0xFFFF) + (hs[3][i] & 0xFFFF);
            }
            int sum = 0;
            for (int count : this.sums) {
                sum += count;
            }
            int targetPercentile = (int)((double)sum * 0.99);
            for (sizeBucket = 0; sizeBucket < this.sums.length && this.sums[sizeBucket] <= targetPercentile; targetPercentile -= this.sums[sizeBucket], ++sizeBucket) {
            }
            int percentileSize = 1 << sizeBucket + 13;
            this.localPrefChunkSize = prefChunkSize = Math.max(percentileSize * 10, 131072);
            if (this.shareable) {
                for (Magazine mag : this.parent.magazines) {
                    prefChunkSize = Math.max(prefChunkSize, mag.localPrefChunkSize);
                }
            }
            if (this.sharedPrefChunkSize != prefChunkSize) {
                this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
                this.sharedPrefChunkSize = prefChunkSize;
            } else {
                this.datumTarget = Math.min(this.datumTarget << 1, 65534);
            }
            this.histoIndex = this.histoIndex + 1 & 3;
            this.histo = this.histos[this.histoIndex];
            this.datumCount = 0;
            Arrays.fill(this.histo, (short)0);
        }

        protected int preferredChunkSize() {
            return this.sharedPrefChunkSize;
        }
    }

    static enum MagazineCaching {
        EventLoopThreads,
        FastThreadLocalThreads,
        None;

    }
}

