/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import shaded.bqjdbc.io.netty.buffer.AbstractByteBuf;
import shaded.bqjdbc.io.netty.buffer.ByteBuf;
import shaded.bqjdbc.io.netty.buffer.SlicedByteBuf;
import shaded.bqjdbc.io.netty.buffer.WrappedByteBuf;
import shaded.bqjdbc.io.netty.util.internal.PlatformDependent;

public class UnsafeDirectLittleEndian
extends WrappedByteBuf {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    public final long id = ID_GENERATOR.incrementAndGet();
    private final AbstractByteBuf wrapped;
    private final long memoryAddress;

    public UnsafeDirectLittleEndian(AbstractByteBuf buf) {
        super(buf);
        this.wrapped = buf;
        this.memoryAddress = buf.memoryAddress();
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }

    @Override
    public long getLong(int index) {
        long v = PlatformDependent.getLong(this.addr(index));
        return v;
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public ByteBuf slice() {
        return this.slice(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ByteBuf slice(int index, int length) {
        return new SlicedByteBuf(this, index, length);
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        return this;
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public int getInt(int index) {
        int v = PlatformDependent.getInt(this.addr(index));
        return v;
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public short getShort(int index) {
        short v = PlatformDependent.getShort(this.addr(index));
        return v;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.wrapped.checkIndex(index, 2);
        this.setShort_(index, value);
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.wrapped.checkIndex(index, 4);
        this.setInt_(index, value);
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.wrapped.checkIndex(index, 8);
        this.setLong_(index, value);
        return this;
    }

    @Override
    public ByteBuf setChar(int index, int value) {
        this.setShort(index, value);
        return this;
    }

    @Override
    public ByteBuf setFloat(int index, float value) {
        this.setInt(index, Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ByteBuf setDouble(int index, double value) {
        this.setLong(index, Double.doubleToRawLongBits(value));
        return this;
    }

    @Override
    public ByteBuf writeShort(int value) {
        this.wrapped.ensureWritable(2);
        this.setShort_(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeInt(int value) {
        this.wrapped.ensureWritable(4);
        this.setInt_(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long value) {
        this.wrapped.ensureWritable(8);
        this.setLong_(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
        return this;
    }

    private void setShort_(int index, int value) {
        PlatformDependent.putShort(this.addr(index), (short)value);
    }

    private void setInt_(int index, int value) {
        PlatformDependent.putInt(this.addr(index), value);
    }

    private void setLong_(int index, long value) {
        PlatformDependent.putLong(this.addr(index), value);
    }

    @Override
    public byte getByte(int index) {
        return PlatformDependent.getByte(this.addr(index));
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        PlatformDependent.putByte(this.addr(index), (byte)value);
        return this;
    }

    @Override
    public boolean release() {
        return this.release(1);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.wrapped.checkIndex(index, length);
        byte[] tmp = new byte[length];
        int readBytes = in.read(tmp);
        if (readBytes > 0) {
            PlatformDependent.copyMemory(tmp, 0, this.addr(index), (long)readBytes);
        }
        return readBytes;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.wrapped.checkIndex(index, length);
        if (length != 0) {
            byte[] tmp = new byte[length];
            PlatformDependent.copyMemory(this.addr(index), tmp, 0, (long)length);
            out.write(tmp);
        }
        return this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }
}

