/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.opencensus.trace.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import shaded.bqjdbc.io.opencensus.common.Timestamp;
import shaded.bqjdbc.io.opencensus.internal.Utils;
import shaded.bqjdbc.io.opencensus.trace.Annotation;
import shaded.bqjdbc.io.opencensus.trace.AttributeValue;
import shaded.bqjdbc.io.opencensus.trace.BaseMessageEvent;
import shaded.bqjdbc.io.opencensus.trace.Link;
import shaded.bqjdbc.io.opencensus.trace.MessageEvent;
import shaded.bqjdbc.io.opencensus.trace.NetworkEvent;
import shaded.bqjdbc.io.opencensus.trace.Span;
import shaded.bqjdbc.io.opencensus.trace.SpanContext;
import shaded.bqjdbc.io.opencensus.trace.SpanId;
import shaded.bqjdbc.io.opencensus.trace.Status;
import shaded.bqjdbc.io.opencensus.trace.export.AutoValue_SpanData;
import shaded.bqjdbc.io.opencensus.trace.export.AutoValue_SpanData_Attributes;
import shaded.bqjdbc.io.opencensus.trace.export.AutoValue_SpanData_Links;
import shaded.bqjdbc.io.opencensus.trace.export.AutoValue_SpanData_TimedEvent;
import shaded.bqjdbc.io.opencensus.trace.export.AutoValue_SpanData_TimedEvents;
import shaded.bqjdbc.io.opencensus.trace.internal.BaseMessageEventUtils;

@Immutable
public abstract class SpanData {
    @Deprecated
    public static SpanData create(SpanContext context, @Nullable SpanId parentSpanId, @Nullable Boolean hasRemoteParent, String name, Timestamp startTimestamp, Attributes attributes, TimedEvents<Annotation> annotations, TimedEvents<? extends BaseMessageEvent> messageOrNetworkEvents, Links links, @Nullable Integer childSpanCount, @Nullable Status status, @Nullable Timestamp endTimestamp) {
        return SpanData.create(context, parentSpanId, hasRemoteParent, name, null, startTimestamp, attributes, annotations, messageOrNetworkEvents, links, childSpanCount, status, endTimestamp);
    }

    public static SpanData create(SpanContext context, @Nullable SpanId parentSpanId, @Nullable Boolean hasRemoteParent, String name, @Nullable Span.Kind kind, Timestamp startTimestamp, Attributes attributes, TimedEvents<Annotation> annotations, TimedEvents<? extends BaseMessageEvent> messageOrNetworkEvents, Links links, @Nullable Integer childSpanCount, @Nullable Status status, @Nullable Timestamp endTimestamp) {
        Utils.checkNotNull(messageOrNetworkEvents, "messageOrNetworkEvents");
        ArrayList messageEventsList = new ArrayList();
        for (TimedEvent<? extends BaseMessageEvent> timedEvent : messageOrNetworkEvents.getEvents()) {
            BaseMessageEvent event = timedEvent.getEvent();
            if (event instanceof MessageEvent) {
                TimedEvent<? extends BaseMessageEvent> timedMessageEvent = timedEvent;
                messageEventsList.add(timedMessageEvent);
                continue;
            }
            messageEventsList.add(TimedEvent.create(timedEvent.getTimestamp(), BaseMessageEventUtils.asMessageEvent(event)));
        }
        TimedEvents<MessageEvent> messageEvents = TimedEvents.create(messageEventsList, messageOrNetworkEvents.getDroppedEventsCount());
        return new AutoValue_SpanData(context, parentSpanId, hasRemoteParent, name, kind, startTimestamp, attributes, annotations, messageEvents, links, childSpanCount, status, endTimestamp);
    }

    public abstract SpanContext getContext();

    @Nullable
    public abstract SpanId getParentSpanId();

    @Nullable
    public abstract Boolean getHasRemoteParent();

    public abstract String getName();

    @Nullable
    public abstract Span.Kind getKind();

    public abstract Timestamp getStartTimestamp();

    public abstract Attributes getAttributes();

    public abstract TimedEvents<Annotation> getAnnotations();

    @Deprecated
    public TimedEvents<NetworkEvent> getNetworkEvents() {
        TimedEvents<MessageEvent> timedEvents = this.getMessageEvents();
        ArrayList networkEventsList = new ArrayList();
        for (TimedEvent<MessageEvent> timedEvent : timedEvents.getEvents()) {
            networkEventsList.add(TimedEvent.create(timedEvent.getTimestamp(), BaseMessageEventUtils.asNetworkEvent(timedEvent.getEvent())));
        }
        return TimedEvents.create(networkEventsList, timedEvents.getDroppedEventsCount());
    }

    public abstract TimedEvents<MessageEvent> getMessageEvents();

    public abstract Links getLinks();

    @Nullable
    public abstract Integer getChildSpanCount();

    @Nullable
    public abstract Status getStatus();

    @Nullable
    public abstract Timestamp getEndTimestamp();

    SpanData() {
    }

    @Immutable
    public static abstract class Links {
        public static Links create(List<Link> links, int droppedLinksCount) {
            return new AutoValue_SpanData_Links(Collections.unmodifiableList(new ArrayList(Utils.checkNotNull(links, "links"))), droppedLinksCount);
        }

        public abstract List<Link> getLinks();

        public abstract int getDroppedLinksCount();

        Links() {
        }
    }

    @Immutable
    public static abstract class Attributes {
        public static Attributes create(Map<String, AttributeValue> attributeMap, int droppedAttributesCount) {
            return new AutoValue_SpanData_Attributes(Collections.unmodifiableMap(new HashMap<String, AttributeValue>(Utils.checkNotNull(attributeMap, "attributeMap"))), droppedAttributesCount);
        }

        public abstract Map<String, AttributeValue> getAttributeMap();

        public abstract int getDroppedAttributesCount();

        Attributes() {
        }
    }

    @Immutable
    public static abstract class TimedEvents<T> {
        public static <T> TimedEvents<T> create(List<TimedEvent<T>> events, int droppedEventsCount) {
            return new AutoValue_SpanData_TimedEvents(Collections.unmodifiableList(new ArrayList(Utils.checkNotNull(events, "events"))), droppedEventsCount);
        }

        public abstract List<TimedEvent<T>> getEvents();

        public abstract int getDroppedEventsCount();

        TimedEvents() {
        }
    }

    @Immutable
    public static abstract class TimedEvent<T> {
        public static <T> TimedEvent<T> create(Timestamp timestamp, T event) {
            return new AutoValue_SpanData_TimedEvent<T>(timestamp, event);
        }

        public abstract Timestamp getTimestamp();

        public abstract T getEvent();

        TimedEvent() {
        }
    }
}

