/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.opentelemetry.api.common;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import shaded.bqjdbc.io.opentelemetry.api.common.KeyValue;
import shaded.bqjdbc.io.opentelemetry.api.common.KeyValueList;
import shaded.bqjdbc.io.opentelemetry.api.common.ValueArray;
import shaded.bqjdbc.io.opentelemetry.api.common.ValueBoolean;
import shaded.bqjdbc.io.opentelemetry.api.common.ValueBytes;
import shaded.bqjdbc.io.opentelemetry.api.common.ValueDouble;
import shaded.bqjdbc.io.opentelemetry.api.common.ValueLong;
import shaded.bqjdbc.io.opentelemetry.api.common.ValueString;
import shaded.bqjdbc.io.opentelemetry.api.common.ValueType;

public interface Value<T> {
    public static Value<String> of(String value) {
        return ValueString.create(value);
    }

    public static Value<Boolean> of(boolean value) {
        return ValueBoolean.create(value);
    }

    public static Value<Long> of(long value) {
        return ValueLong.create(value);
    }

    public static Value<Double> of(double value) {
        return ValueDouble.create(value);
    }

    public static Value<ByteBuffer> of(byte[] value) {
        return ValueBytes.create(value);
    }

    public static Value<List<Value<?>>> of(Value<?> ... value) {
        return ValueArray.create(value);
    }

    public static Value<List<Value<?>>> of(List<Value<?>> value) {
        return ValueArray.create(value);
    }

    public static Value<List<KeyValue>> of(KeyValue ... value) {
        return KeyValueList.create(value);
    }

    public static Value<List<KeyValue>> of(Map<String, Value<?>> value) {
        return KeyValueList.createFromMap(value);
    }

    public ValueType getType();

    public T getValue();

    public String asString();
}

