/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.opentelemetry.api.common;

import java.util.Objects;
import shaded.bqjdbc.io.opentelemetry.api.common.Value;
import shaded.bqjdbc.io.opentelemetry.api.common.ValueType;

final class ValueDouble
implements Value<Double> {
    private final double value;

    private ValueDouble(double value) {
        this.value = value;
    }

    static Value<Double> create(double value) {
        return new ValueDouble(value);
    }

    @Override
    public ValueType getType() {
        return ValueType.DOUBLE;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    public String toString() {
        return "ValueDouble{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Value && Objects.equals(this.value, ((Value)o).getValue());
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }
}

