/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.io.opentelemetry.api.internal;

import java.util.Objects;
import shaded.bqjdbc.io.opentelemetry.context.Context;
import shaded.bqjdbc.io.opentelemetry.context.ContextKey;

public final class InstrumentationUtil {
    private static final ContextKey<Boolean> SUPPRESS_INSTRUMENTATION_KEY = ContextKey.named("suppress_instrumentation");

    private InstrumentationUtil() {
    }

    public static void suppressInstrumentation(Runnable runnable) {
        Context.current().with(SUPPRESS_INSTRUMENTATION_KEY, true).wrap(runnable).run();
    }

    public static boolean shouldSuppressInstrumentation(Context context) {
        return Objects.equals(context.get(SUPPRESS_INSTRUMENTATION_KEY), true);
    }
}

