/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.arrow.vector;

import java.util.List;
import shaded.bqjdbc.org.apache.arrow.memory.ArrowBuf;
import shaded.bqjdbc.org.apache.arrow.vector.BufferBacked;
import shaded.bqjdbc.org.apache.arrow.vector.ValueVector;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import shaded.bqjdbc.org.apache.arrow.vector.types.pojo.Field;

public interface FieldVector
extends ValueVector {
    public void initializeChildrenFromFields(List<Field> var1);

    public List<FieldVector> getChildrenFromFields();

    public void loadFieldBuffers(ArrowFieldNode var1, List<ArrowBuf> var2);

    public List<ArrowBuf> getFieldBuffers();

    default public int getExportedCDataBufferCount() {
        return this.getFieldBuffers().size();
    }

    default public void exportBuffer(ArrowBuf buffer, List<ArrowBuf> buffers, ArrowBuf buffersPtr, long nullValue, boolean retain) {
        if (buffer != null) {
            if (retain) {
                buffer.getReferenceManager().retain();
            }
            buffersPtr.writeLong(buffer.memoryAddress());
        } else {
            buffersPtr.writeLong(nullValue);
        }
        buffers.add(buffer);
    }

    default public void exportCDataBuffers(List<ArrowBuf> buffers, ArrowBuf buffersPtr, long nullValue) {
        List<ArrowBuf> fieldBuffers = this.getFieldBuffers();
        for (ArrowBuf arrowBuf : fieldBuffers) {
            this.exportBuffer(arrowBuf, buffers, buffersPtr, nullValue, true);
        }
    }

    @Deprecated
    public List<BufferBacked> getFieldInnerVectors();

    public long getValidityBufferAddress();

    public long getDataBufferAddress();

    public long getOffsetBufferAddress();

    public void setNull(int var1);
}

