/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.arrow.vector;

import shaded.bqjdbc.org.apache.arrow.memory.ArrowBuf;
import shaded.bqjdbc.org.apache.arrow.memory.BufferAllocator;
import shaded.bqjdbc.org.apache.arrow.vector.BaseFixedWidthVector;
import shaded.bqjdbc.org.apache.arrow.vector.BaseIntVector;
import shaded.bqjdbc.org.apache.arrow.vector.BitVectorHelper;
import shaded.bqjdbc.org.apache.arrow.vector.NullCheckingForGet;
import shaded.bqjdbc.org.apache.arrow.vector.ValueIterableVector;
import shaded.bqjdbc.org.apache.arrow.vector.ValueVector;
import shaded.bqjdbc.org.apache.arrow.vector.complex.impl.SmallIntReaderImpl;
import shaded.bqjdbc.org.apache.arrow.vector.complex.reader.FieldReader;
import shaded.bqjdbc.org.apache.arrow.vector.holders.NullableSmallIntHolder;
import shaded.bqjdbc.org.apache.arrow.vector.holders.SmallIntHolder;
import shaded.bqjdbc.org.apache.arrow.vector.types.Types;
import shaded.bqjdbc.org.apache.arrow.vector.types.pojo.Field;
import shaded.bqjdbc.org.apache.arrow.vector.types.pojo.FieldType;
import shaded.bqjdbc.org.apache.arrow.vector.util.TransferPair;

public final class SmallIntVector
extends BaseFixedWidthVector
implements BaseIntVector,
ValueIterableVector<Short> {
    public static final byte TYPE_WIDTH = 2;

    public SmallIntVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.SMALLINT.getType()), allocator);
    }

    public SmallIntVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public SmallIntVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 2);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new SmallIntReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.SMALLINT;
    }

    public short get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getShort((long)index * 2L);
    }

    public void get(int index, NullableSmallIntHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getShort((long)index * 2L);
    }

    @Override
    public Short getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getShort((long)index * 2L);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setShort((long)index * 2L, value);
    }

    private void setValue(int index, short value) {
        this.valueBuffer.setShort((long)index * 2L, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, short value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableSmallIntHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, SmallIntHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, short value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableSmallIntHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, SmallIntHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, short value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, short value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static short get(ArrowBuf buffer, int index) {
        return buffer.getShort((long)index * 2L);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((SmallIntVector)to);
    }

    @Override
    public void setWithPossibleTruncate(int index, long value) {
        this.setSafe(index, (int)value);
    }

    @Override
    public void setUnsafeWithPossibleTruncate(int index, long value) {
        this.set(index, (int)value);
    }

    @Override
    public long getValueAsLong(int index) {
        return this.get(index);
    }

    private class TransferImpl
    implements TransferPair {
        SmallIntVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new SmallIntVector(ref, SmallIntVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new SmallIntVector(field, allocator);
        }

        public TransferImpl(SmallIntVector to) {
            this.to = to;
        }

        @Override
        public SmallIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            SmallIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            SmallIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, SmallIntVector.this);
        }
    }
}

