/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.arrow.vector.complex.impl;

import java.time.LocalDateTime;
import shaded.bqjdbc.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import shaded.bqjdbc.org.apache.arrow.vector.complex.writer.DateMilliWriter;
import shaded.bqjdbc.org.apache.arrow.vector.holders.DateMilliHolder;
import shaded.bqjdbc.org.apache.arrow.vector.holders.NullableDateMilliHolder;
import shaded.bqjdbc.org.apache.arrow.vector.types.Types;
import shaded.bqjdbc.org.apache.arrow.vector.util.DateUtility;

public class DateMilliHolderReaderImpl
extends AbstractFieldReader {
    private DateMilliHolder holder;

    public DateMilliHolderReaderImpl(DateMilliHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DATEMILLI;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(DateMilliHolder h2) {
        h2.value = this.holder.value;
    }

    @Override
    public void read(NullableDateMilliHolder h2) {
        h2.value = this.holder.value;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        return DateUtility.getLocalDateTimeFromEpochMilli(this.holder.value);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }

    @Override
    public void copyAsValue(DateMilliWriter writer) {
        writer.write(this.holder);
    }
}

