/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.arrow.vector.complex.impl;

import java.time.Duration;
import shaded.bqjdbc.org.apache.arrow.vector.DurationVector;
import shaded.bqjdbc.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import shaded.bqjdbc.org.apache.arrow.vector.holders.DurationHolder;
import shaded.bqjdbc.org.apache.arrow.vector.holders.NullableDurationHolder;
import shaded.bqjdbc.org.apache.arrow.vector.types.Types;

public class NullableDurationHolderReaderImpl
extends AbstractFieldReader {
    private NullableDurationHolder holder;

    public NullableDurationHolderReaderImpl(NullableDurationHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DURATION;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(DurationHolder h2) {
        h2.value = this.holder.value;
        h2.unit = this.holder.unit;
    }

    @Override
    public void read(NullableDurationHolder h2) {
        h2.value = this.holder.value;
        h2.unit = this.holder.unit;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Duration readDuration() {
        if (!this.isSet()) {
            return null;
        }
        return DurationVector.toDuration(this.holder.value, this.holder.unit);
    }

    @Override
    public Object readObject() {
        return this.readDuration();
    }
}

