/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.arrow.vector.dictionary;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import shaded.bqjdbc.org.apache.arrow.memory.BufferAllocator;
import shaded.bqjdbc.org.apache.arrow.util.VisibleForTesting;
import shaded.bqjdbc.org.apache.arrow.vector.dictionary.Dictionary;

public interface DictionaryProvider {
    public Dictionary lookup(long var1);

    public Set<Long> getDictionaryIds();

    public static class MapDictionaryProvider
    implements AutoCloseable,
    DictionaryProvider {
        private final Map<Long, Dictionary> map = new HashMap<Long, Dictionary>();

        public MapDictionaryProvider(Dictionary ... dictionaries) {
            for (Dictionary dictionary : dictionaries) {
                this.put(dictionary);
            }
        }

        @VisibleForTesting
        public void copyStructureFrom(DictionaryProvider other, BufferAllocator allocator) {
            for (Long id : other.getDictionaryIds()) {
                Dictionary otherDict = other.lookup(id);
                Dictionary newDict = new Dictionary(otherDict.getVector().getField().createVector(allocator), otherDict.getEncoding());
                this.put(newDict);
            }
        }

        public void put(Dictionary dictionary) {
            this.map.put(dictionary.getEncoding().getId(), dictionary);
        }

        @Override
        public final Set<Long> getDictionaryIds() {
            return this.map.keySet();
        }

        @Override
        public Dictionary lookup(long id) {
            return this.map.get(id);
        }

        @Override
        public void close() {
            for (Dictionary dictionary : this.map.values()) {
                dictionary.getVector().close();
            }
        }
    }
}

