/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.arrow.vector.util;

import java.util.Collection;
import java.util.Set;
import shaded.bqjdbc.org.apache.arrow.vector.complex.AbstractStructVector;
import shaded.bqjdbc.org.apache.arrow.vector.util.MapWithOrdinal;
import shaded.bqjdbc.org.apache.arrow.vector.util.MapWithOrdinalImpl;
import shaded.bqjdbc.org.apache.arrow.vector.util.MultiMapWithOrdinal;

public class PromotableMultiMapWithOrdinal<K, V>
implements MapWithOrdinal<K, V> {
    private final MapWithOrdinalImpl<K, V> mapWithOrdinal = new MapWithOrdinalImpl();
    private final MultiMapWithOrdinal<K, V> multiMapWithOrdinal = new MultiMapWithOrdinal();
    private final boolean promotable;
    private AbstractStructVector.ConflictPolicy conflictPolicy;
    private MapWithOrdinal<K, V> delegate;

    public PromotableMultiMapWithOrdinal(boolean promotable, AbstractStructVector.ConflictPolicy conflictPolicy) {
        this.promotable = promotable;
        this.conflictPolicy = conflictPolicy;
        this.delegate = this.mapWithOrdinal;
    }

    private void promote() {
        if (this.delegate == this.multiMapWithOrdinal || !this.promotable || this.conflictPolicy.equals((Object)AbstractStructVector.ConflictPolicy.CONFLICT_REPLACE)) {
            return;
        }
        for (K key : this.mapWithOrdinal.keys()) {
            V value = this.mapWithOrdinal.get(key);
            this.multiMapWithOrdinal.put(key, value, false);
        }
        this.mapWithOrdinal.clear();
        this.delegate = this.multiMapWithOrdinal;
    }

    @Override
    public V getByOrdinal(int id) {
        return this.delegate.getByOrdinal(id);
    }

    @Override
    public int getOrdinal(K key) {
        return this.delegate.getOrdinal(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public V get(K key) {
        return this.delegate.get(key);
    }

    @Override
    public Collection<V> getAll(K key) {
        return this.delegate.getAll(key);
    }

    @Override
    public boolean put(K key, V value, boolean overwrite) {
        if (this.delegate.containsKey(key)) {
            this.promote();
        }
        return this.delegate.put(key, value, overwrite);
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean remove(K key, V value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean removeAll(K key) {
        return this.delegate.removeAll(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keys() {
        return this.delegate.keys();
    }

    public void setConflictPolicy(AbstractStructVector.ConflictPolicy conflictPolicy) {
        this.conflictPolicy = conflictPolicy;
    }
}

