/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.arrow.vector.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import shaded.bqjdbc.org.apache.arrow.memory.BufferAllocator;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.ReadChannel;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.WriteChannel;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.message.MessageChannelReader;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.message.MessageResult;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.message.MessageSerializer;
import shaded.bqjdbc.org.apache.arrow.vector.types.pojo.Schema;
import shaded.bqjdbc.org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;

public class SchemaUtility {
    private SchemaUtility() {
    }

    public static Schema deserialize(byte[] bytes, BufferAllocator allocator) throws IOException {
        try (MessageChannelReader schemaReader = new MessageChannelReader(new ReadChannel(new ByteArrayReadableSeekableByteChannel(bytes)), allocator);){
            MessageResult result = schemaReader.readNext();
            if (result == null) {
                throw new IOException("Unexpected end of input. Missing schema.");
            }
            Schema schema = MessageSerializer.deserializeSchema(result.getMessage());
            return schema;
        }
    }

    public static byte[] serialize(Schema schema) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageSerializer.serialize(new WriteChannel(Channels.newChannel(out)), schema);
        return out.toByteArray();
    }
}

