/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.hc.client5.http.impl.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.AuthChallenge;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.AuthScheme;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.AuthScope;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.AuthStateCacheable;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.AuthenticationException;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.BearerToken;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.Credentials;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.CredentialsProvider;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.MalformedChallengeException;
import shaded.bqjdbc.org.apache.hc.client5.http.protocol.HttpClientContext;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpHost;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpRequest;
import shaded.bqjdbc.org.apache.hc.core5.http.NameValuePair;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.HttpContext;
import shaded.bqjdbc.org.apache.hc.core5.util.Args;
import shaded.bqjdbc.org.apache.hc.core5.util.Asserts;
import shaded.bqjdbc.org.slf4j.Logger;
import shaded.bqjdbc.org.slf4j.LoggerFactory;

@AuthStateCacheable
public class BearerScheme
implements AuthScheme,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(BearerScheme.class);
    private final Map<String, String> paramMap = new HashMap<String, String>();
    private boolean complete = false;
    private BearerToken bearerToken;

    @Override
    public String getName() {
        return "Bearer";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String getRealm() {
        return this.paramMap.get("realm");
    }

    @Override
    public void processChallenge(AuthChallenge authChallenge, HttpContext context) throws MalformedChallengeException {
        this.paramMap.clear();
        List<NameValuePair> params = authChallenge.getParams();
        if (params != null) {
            String error;
            for (NameValuePair param : params) {
                this.paramMap.put(param.getName().toLowerCase(Locale.ROOT), param.getValue());
            }
            if (LOG.isDebugEnabled() && (error = this.paramMap.get("error")) != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(error);
                String desc = this.paramMap.get("error_description");
                String uri = this.paramMap.get("error_uri");
                if (desc != null || uri != null) {
                    buf.append(" (");
                    buf.append(desc).append("; ").append(uri);
                    buf.append(")");
                }
                LOG.debug(buf.toString());
            }
        }
        this.complete = true;
    }

    @Override
    public boolean isChallengeComplete() {
        return this.complete;
    }

    @Override
    public boolean isResponseReady(HttpHost host, CredentialsProvider credentialsProvider, HttpContext context) throws AuthenticationException {
        Args.notNull(host, "Auth host");
        Args.notNull(credentialsProvider, "Credentials provider");
        AuthScope authScope = new AuthScope(host, this.getRealm(), this.getName());
        Credentials credentials = credentialsProvider.getCredentials(authScope, context);
        if (credentials instanceof BearerToken) {
            this.bearerToken = (BearerToken)credentials;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            HttpClientContext clientContext = HttpClientContext.adapt(context);
            String exchangeId = clientContext.getExchangeId();
            LOG.debug("{} No credentials found for auth scope [{}]", (Object)exchangeId, (Object)authScope);
        }
        this.bearerToken = null;
        return false;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public String generateAuthResponse(HttpHost host, HttpRequest request, HttpContext context) throws AuthenticationException {
        Asserts.notNull(this.bearerToken, "Bearer token");
        return "Bearer " + this.bearerToken.getToken();
    }

    public String toString() {
        return this.getName() + this.paramMap;
    }
}

