/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import shaded.bqjdbc.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import shaded.bqjdbc.org.apache.hc.client5.http.HttpRoute;
import shaded.bqjdbc.org.apache.hc.client5.http.UserTokenHandler;
import shaded.bqjdbc.org.apache.hc.client5.http.classic.ExecChain;
import shaded.bqjdbc.org.apache.hc.client5.http.classic.ExecChainHandler;
import shaded.bqjdbc.org.apache.hc.client5.http.classic.ExecRuntime;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.ConnectionShutdownException;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import shaded.bqjdbc.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import shaded.bqjdbc.org.apache.hc.client5.http.protocol.HttpClientContext;
import shaded.bqjdbc.org.apache.hc.core5.annotation.Contract;
import shaded.bqjdbc.org.apache.hc.core5.annotation.Internal;
import shaded.bqjdbc.org.apache.hc.core5.annotation.ThreadingBehavior;
import shaded.bqjdbc.org.apache.hc.core5.http.ClassicHttpRequest;
import shaded.bqjdbc.org.apache.hc.core5.http.ClassicHttpResponse;
import shaded.bqjdbc.org.apache.hc.core5.http.ConnectionReuseStrategy;
import shaded.bqjdbc.org.apache.hc.core5.http.EntityDetails;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpEntity;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpException;
import shaded.bqjdbc.org.apache.hc.core5.http.message.RequestLine;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.HttpContext;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.HttpProcessor;
import shaded.bqjdbc.org.apache.hc.core5.io.CloseMode;
import shaded.bqjdbc.org.apache.hc.core5.util.Args;
import shaded.bqjdbc.org.apache.hc.core5.util.TimeValue;
import shaded.bqjdbc.org.slf4j.Logger;
import shaded.bqjdbc.org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class MainClientExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MainClientExec.class);
    private final HttpClientConnectionManager connectionManager;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final UserTokenHandler userTokenHandler;

    public MainClientExec(HttpClientConnectionManager connectionManager, HttpProcessor httpProcessor, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, UserTokenHandler userTokenHandler) {
        this.connectionManager = Args.notNull(connectionManager, "Connection manager");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP protocol processor");
        this.reuseStrategy = Args.notNull(reuseStrategy, "Connection reuse strategy");
        this.keepAliveStrategy = Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.userTokenHandler = Args.notNull(userTokenHandler, "User token handler");
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        ExecRuntime execRuntime = scope.execRuntime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} executing {}", (Object)exchangeId, (Object)new RequestLine(request));
        }
        try {
            context.setAttribute("http.route", route);
            context.setAttribute("http.request", request);
            this.httpProcessor.process(request, (EntityDetails)request.getEntity(), (HttpContext)context);
            ClassicHttpResponse response = execRuntime.execute(exchangeId, request, context);
            context.setAttribute("http.response", response);
            this.httpProcessor.process(response, (EntityDetails)response.getEntity(), (HttpContext)context);
            Object userToken = context.getUserToken();
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken(route, request, context);
                context.setAttribute("http.user-token", userToken);
            }
            if (this.reuseStrategy.keepAlive(request, response, context)) {
                TimeValue duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                if (LOG.isDebugEnabled()) {
                    String s2 = duration != null ? "for " + duration : "indefinitely";
                    LOG.debug("{} connection can be kept alive {}", (Object)exchangeId, (Object)s2);
                }
                execRuntime.markConnectionReusable(userToken, duration);
            } else {
                execRuntime.markConnectionNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                execRuntime.releaseEndpoint();
                return new CloseableHttpResponse(response, null);
            }
            return new CloseableHttpResponse(response, execRuntime);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            execRuntime.discardEndpoint();
            throw ioex;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            execRuntime.discardEndpoint();
            throw ex;
        }
        catch (Error error) {
            this.connectionManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }
}

