/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.net.Socket;
import shaded.bqjdbc.org.apache.hc.client5.http.AuthenticationStrategy;
import shaded.bqjdbc.org.apache.hc.client5.http.HttpRoute;
import shaded.bqjdbc.org.apache.hc.client5.http.RouteInfo;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.AuthExchange;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.AuthScope;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.ChallengeType;
import shaded.bqjdbc.org.apache.hc.client5.http.auth.Credentials;
import shaded.bqjdbc.org.apache.hc.client5.http.config.RequestConfig;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.TunnelRefusedException;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.auth.HttpAuthenticator;
import shaded.bqjdbc.org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import shaded.bqjdbc.org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import shaded.bqjdbc.org.apache.hc.client5.http.protocol.RequestClientConnControl;
import shaded.bqjdbc.org.apache.hc.core5.http.ClassicHttpResponse;
import shaded.bqjdbc.org.apache.hc.core5.http.ConnectionReuseStrategy;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpEntity;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpException;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpHost;
import shaded.bqjdbc.org.apache.hc.core5.http.Method;
import shaded.bqjdbc.org.apache.hc.core5.http.config.CharCodingConfig;
import shaded.bqjdbc.org.apache.hc.core5.http.config.Http1Config;
import shaded.bqjdbc.org.apache.hc.core5.http.config.Lookup;
import shaded.bqjdbc.org.apache.hc.core5.http.config.RegistryBuilder;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import shaded.bqjdbc.org.apache.hc.core5.http.io.HttpConnectionFactory;
import shaded.bqjdbc.org.apache.hc.core5.http.io.entity.EntityUtils;
import shaded.bqjdbc.org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import shaded.bqjdbc.org.apache.hc.core5.http.message.StatusLine;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.BasicHttpContext;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.HttpProcessor;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.RequestTargetHost;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.RequestUserAgent;
import shaded.bqjdbc.org.apache.hc.core5.util.Args;

public class ProxyClient {
    private final HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthExchange proxyAuthExchange;
    private final Lookup<AuthSchemeFactory> authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<ManagedHttpClientConnection> connFactory, Http1Config h1Config, CharCodingConfig charCodingConfig, RequestConfig requestConfig) {
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.builder().http1Config(h1Config).charCodingConfig(charCodingConfig).build();
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new DefaultHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new DefaultAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthExchange = new AuthExchange();
        this.authSchemeRegistry = RegistryBuilder.create().register("Basic", BasicSchemeFactory.INSTANCE).register("Digest", (BasicSchemeFactory)((Object)DigestSchemeFactory.INSTANCE)).build();
        this.reuseStrategy = DefaultClientConnectionReuseStrategy.INSTANCE;
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null, null);
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        HttpEntity entity;
        int status;
        ClassicHttpResponse response;
        Args.notNull(proxy, "Proxy host");
        Args.notNull(target, "Target host");
        Args.notNull(credentials, "Credentials");
        HttpHost host = target;
        if (host.getPort() <= 0) {
            host = new HttpHost(host.getSchemeName(), host.getHostName(), 80);
        }
        HttpRoute route = new HttpRoute(host, null, proxy, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection conn = this.connFactory.createConnection(null);
        BasicHttpContext context = new BasicHttpContext();
        BasicClassicHttpRequest connect = new BasicClassicHttpRequest(Method.CONNECT, proxy, host.toHostString());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxy), credentials);
        context.setAttribute("http.request", connect);
        context.setAttribute("http.route", route);
        context.setAttribute("http.auth.credentials-provider", credsProvider);
        context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        context.setAttribute("http.request-config", this.requestConfig);
        this.requestExec.preProcess(connect, this.httpProcessor, context);
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket);
            }
            this.authenticator.addAuthResponse(proxy, ChallengeType.PROXY, connect, this.proxyAuthExchange, context);
            response = this.requestExec.execute(connect, conn, context);
            status = response.getCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response);
            }
            if (!this.authenticator.isChallenged(proxy, ChallengeType.PROXY, response, this.proxyAuthExchange, context) || !this.authenticator.updateAuthState(proxy, ChallengeType.PROXY, response, this.proxyAuthStrategy, this.proxyAuthExchange, context)) break;
            if (this.reuseStrategy.keepAlive(connect, response, context)) {
                entity = response.getEntity();
                EntityUtils.consume(entity);
            } else {
                conn.close();
            }
            connect.removeHeaders("Proxy-Authorization");
        }
        status = response.getCode();
        if (status > 299) {
            entity = response.getEntity();
            String responseMessage = entity != null ? EntityUtils.toString(entity) : null;
            conn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + new StatusLine(response), responseMessage);
        }
        return conn.getSocket();
    }
}

