/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.hc.client5.http.ssl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.conscrypt.Conscrypt;
import shaded.bqjdbc.org.apache.hc.client5.http.ssl.AbstractClientTlsStrategy;
import shaded.bqjdbc.org.apache.hc.client5.http.ssl.HttpsSupport;
import shaded.bqjdbc.org.apache.hc.core5.annotation.Contract;
import shaded.bqjdbc.org.apache.hc.core5.annotation.ThreadingBehavior;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import shaded.bqjdbc.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import shaded.bqjdbc.org.apache.hc.core5.reactor.ssl.TlsDetails;
import shaded.bqjdbc.org.apache.hc.core5.ssl.SSLContexts;

@Contract(threading=ThreadingBehavior.STATELESS)
public class ConscryptClientTlsStrategy
extends AbstractClientTlsStrategy {
    public static TlsStrategy getDefault() {
        return new ConscryptClientTlsStrategy(SSLContexts.createDefault(), HttpsSupport.getDefaultHostnameVerifier());
    }

    public static TlsStrategy getSystemDefault() {
        return new ConscryptClientTlsStrategy(SSLContexts.createSystemDefault(), HttpsSupport.getSystemProtocols(), HttpsSupport.getSystemCipherSuits(), SSLBufferMode.STATIC, HttpsSupport.getDefaultHostnameVerifier());
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, SSLBufferMode sslBufferManagement, HostnameVerifier hostnameVerifier) {
        super(sslContext, supportedProtocols, supportedCipherSuites, sslBufferManagement, hostnameVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        this(sslContext, null, null, SSLBufferMode.STATIC, hostnameVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext) {
        this(sslContext, HttpsSupport.getDefaultHostnameVerifier());
    }

    @Override
    void applyParameters(SSLEngine sslEngine, SSLParameters sslParameters, String[] appProtocols) {
        if (Conscrypt.isConscrypt(sslEngine)) {
            sslEngine.setSSLParameters(sslParameters);
            Conscrypt.setApplicationProtocols(sslEngine, appProtocols);
        } else {
            sslParameters.setApplicationProtocols(appProtocols);
            sslEngine.setSSLParameters(sslParameters);
        }
    }

    @Override
    TlsDetails createTlsDetails(SSLEngine sslEngine) {
        if (Conscrypt.isConscrypt(sslEngine)) {
            return new TlsDetails(sslEngine.getSession(), Conscrypt.getApplicationProtocol(sslEngine));
        }
        return null;
    }

    public static boolean isSupported() {
        try {
            Class<?> clazz = Class.forName("org.conscrypt.Conscrypt");
            Method method = clazz.getMethod("isAvailable", new Class[0]);
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }
}

